/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import java.util.Map;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.Project;
import org.jclouds.cloudstack.domain.User;
import org.jclouds.cloudstack.features.ProjectApi;
import org.jclouds.cloudstack.options.ListProjectsOptions;
import org.jclouds.collect.Memoized;

public class ProjectsForCurrentUser
implements Supplier<Map<String, Project>> {
    private final CloudStackApi api;
    private final Supplier<User> currentUserSupplier;

    @Inject
    public ProjectsForCurrentUser(CloudStackApi api, @Memoized Supplier<User> currentUserSupplier) {
        this.api = (CloudStackApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        this.currentUserSupplier = (Supplier)Preconditions.checkNotNull(currentUserSupplier, (Object)"currentUserSupplier");
    }

    public Map<String, Project> get() {
        User currentUser = (User)this.currentUserSupplier.get();
        ProjectApi projectApi = this.api.getProjectApi();
        return Maps.uniqueIndex(projectApi.listProjects(ListProjectsOptions.Builder.accountInDomain(currentUser.getAccount(), currentUser.getDomainId())), (Function)new Function<Project, String>(){

            public String apply(Project arg0) {
                return arg0.getId();
            }
        });
    }
}

