/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import org.jclouds.cloudstack.domain.AllocationState;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class UpdateZoneOptions
extends BaseHttpRequestOptions {
    public static final UpdateZoneOptions NONE = new UpdateZoneOptions();

    public UpdateZoneOptions allocationState(AllocationState allocationState) {
        this.queryParameters.replaceValues((Object)"allocationstate", (Iterable)ImmutableSet.of((Object)allocationState.toString()));
        return this;
    }

    public UpdateZoneOptions details(String details) {
        this.queryParameters.replaceValues((Object)"details", (Iterable)ImmutableSet.of((Object)details));
        return this;
    }

    public UpdateZoneOptions dhcpProvider(String dhcpProvider) {
        this.queryParameters.replaceValues((Object)"dhcpprovider", (Iterable)ImmutableSet.of((Object)dhcpProvider));
        return this;
    }

    public UpdateZoneOptions externalDns(List<String> externalDnsServers) {
        Preconditions.checkArgument((externalDnsServers.size() == 1 || externalDnsServers.size() == 2 ? 1 : 0) != 0, (Object)"The list of DNS servers should have 1 or 2 elements");
        this.queryParameters.replaceValues((Object)"dns1", (Iterable)ImmutableSet.of((Object)externalDnsServers.get(0)));
        if (externalDnsServers.size() == 2) {
            this.queryParameters.replaceValues((Object)"dns2", (Iterable)ImmutableSet.of((Object)externalDnsServers.get(1)));
        }
        return this;
    }

    public UpdateZoneOptions internalDns(List<String> internalDnsServers) {
        Preconditions.checkArgument((internalDnsServers.size() == 1 || internalDnsServers.size() == 2 ? 1 : 0) != 0, (Object)"The list of internal DNS servers should have 1 or 2 elements");
        this.queryParameters.replaceValues((Object)"internaldns1", (Iterable)ImmutableSet.of((Object)internalDnsServers.get(0)));
        if (internalDnsServers.size() == 2) {
            this.queryParameters.replaceValues((Object)"internaldns2", (Iterable)ImmutableSet.of((Object)internalDnsServers.get(1)));
        }
        return this;
    }

    public UpdateZoneOptions dnsSearchOrder(String dnsSearchOrder) {
        this.queryParameters.replaceValues((Object)"dnssearchorder", (Iterable)ImmutableSet.of((Object)dnsSearchOrder));
        return this;
    }

    public UpdateZoneOptions domainName(String domainName) {
        this.queryParameters.replaceValues((Object)"domain", (Iterable)ImmutableSet.of((Object)domainName));
        return this;
    }

    public UpdateZoneOptions guestCIDRAddress(String guestCIDRAddress) {
        this.queryParameters.replaceValues((Object)"guestcidraddress", (Iterable)ImmutableSet.of((Object)guestCIDRAddress));
        return this;
    }

    public UpdateZoneOptions securityGroupEnabled(boolean securityGroupEnabled) {
        this.queryParameters.replaceValues((Object)"securitygroupenabled", (Iterable)ImmutableSet.of((Object)("" + securityGroupEnabled)));
        return this;
    }

    public UpdateZoneOptions makePublic() {
        this.queryParameters.replaceValues((Object)"ispublic", (Iterable)ImmutableSet.of((Object)"true"));
        return this;
    }

    public UpdateZoneOptions name(String name) {
        this.queryParameters.replaceValues((Object)"name", (Iterable)ImmutableSet.of((Object)name));
        return this;
    }

    public UpdateZoneOptions vlan(String vlan) {
        this.queryParameters.replaceValues((Object)"vlan", (Iterable)ImmutableSet.of((Object)vlan));
        return this;
    }

    public static class Builder {
        public static UpdateZoneOptions allocationState(AllocationState allocationState) {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.allocationState(allocationState);
        }

        public static UpdateZoneOptions details(String details) {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.details(details);
        }

        public static UpdateZoneOptions dhcpProvider(String dhcpProvider) {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.dhcpProvider(dhcpProvider);
        }

        public static UpdateZoneOptions externalDns(List<String> externalDnsServers) {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.externalDns(externalDnsServers);
        }

        public static UpdateZoneOptions internalDns(List<String> internalDnsServers) {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.internalDns(internalDnsServers);
        }

        public static UpdateZoneOptions dnsSearchOrder(String dnsSearchOrder) {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.dnsSearchOrder(dnsSearchOrder);
        }

        public static UpdateZoneOptions domainName(String domainName) {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.domainName(domainName);
        }

        public static UpdateZoneOptions guestCIDRAddress(String guestCIDRAddress) {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.guestCIDRAddress(guestCIDRAddress);
        }

        public static UpdateZoneOptions securityGroupEnabled(boolean securityGroupEnabled) {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.securityGroupEnabled(securityGroupEnabled);
        }

        public static UpdateZoneOptions makePublic() {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.makePublic();
        }

        public static UpdateZoneOptions name(String name) {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.name(name);
        }

        public static UpdateZoneOptions vlan(String vlan) {
            UpdateZoneOptions options = new UpdateZoneOptions();
            return options.vlan(vlan);
        }
    }
}

