/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.options;

import com.google.common.collect.ImmutableSet;
import java.util.Map;
import org.jclouds.cloudstack.options.AssociateIPAddressOptions;

public class ListSecurityGroupsOptions
extends AssociateIPAddressOptions {
    public static final ListSecurityGroupsOptions NONE = new ListSecurityGroupsOptions();

    public ListSecurityGroupsOptions id(String id) {
        this.queryParameters.replaceValues((Object)"id", (Iterable)ImmutableSet.of((Object)id));
        return this;
    }

    public ListSecurityGroupsOptions named(String securityGroupName) {
        this.queryParameters.replaceValues((Object)"securitygroupname", (Iterable)ImmutableSet.of((Object)securityGroupName));
        return this;
    }

    public ListSecurityGroupsOptions virtualMachineId(String virtualMachineId) {
        this.queryParameters.replaceValues((Object)"virtualmachineid", (Iterable)ImmutableSet.of((Object)virtualMachineId));
        return this;
    }

    @Override
    public ListSecurityGroupsOptions projectId(String projectId) {
        this.queryParameters.replaceValues((Object)"projectid", (Iterable)ImmutableSet.of((Object)projectId));
        return this;
    }

    public ListSecurityGroupsOptions tags(Map<String, String> tags) {
        int count = 0;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.queryParameters.replaceValues((Object)String.format("tags[%d].key", count), (Iterable)ImmutableSet.of((Object)entry.getKey()));
            this.queryParameters.replaceValues((Object)String.format("tags[%d].value", count), (Iterable)ImmutableSet.of((Object)entry.getValue()));
            ++count;
        }
        return this;
    }

    @Override
    public ListSecurityGroupsOptions accountInDomain(String account, String domain) {
        return (ListSecurityGroupsOptions)((Object)ListSecurityGroupsOptions.class.cast((Object)super.accountInDomain(account, domain)));
    }

    @Override
    public ListSecurityGroupsOptions domainId(String domainId) {
        return (ListSecurityGroupsOptions)((Object)ListSecurityGroupsOptions.class.cast((Object)super.domainId(domainId)));
    }

    public static class Builder {
        public static ListSecurityGroupsOptions named(String securityGroupName) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.named(securityGroupName);
        }

        public static ListSecurityGroupsOptions id(String id) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.id(id);
        }

        public static ListSecurityGroupsOptions virtualMachineId(String virtualMachineId) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.virtualMachineId(virtualMachineId);
        }

        public static ListSecurityGroupsOptions projectId(String projectId) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.projectId(projectId);
        }

        public static ListSecurityGroupsOptions accountInDomain(String account, String domain) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.accountInDomain(account, domain);
        }

        public static ListSecurityGroupsOptions domainId(String domainId) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.domainId(domainId);
        }

        public static ListSecurityGroupsOptions tags(Map<String, String> tags) {
            ListSecurityGroupsOptions options = new ListSecurityGroupsOptions();
            return options.tags(tags);
        }
    }
}

