/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.compute.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import jakarta.annotation.Resource;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.jclouds.cloudstack.domain.IngressRule;
import org.jclouds.cloudstack.domain.SecurityGroup;
import org.jclouds.compute.domain.SecurityGroupBuilder;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;

@Singleton
public class CloudStackSecurityGroupToSecurityGroup
implements Function<SecurityGroup, org.jclouds.compute.domain.SecurityGroup> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    protected final Function<IngressRule, IpPermission> ruleToPermission;

    @Inject
    public CloudStackSecurityGroupToSecurityGroup(Function<IngressRule, IpPermission> ruleToPermission) {
        this.ruleToPermission = ruleToPermission;
    }

    public org.jclouds.compute.domain.SecurityGroup apply(SecurityGroup group) {
        SecurityGroupBuilder builder = new SecurityGroupBuilder();
        builder.id(group.getId());
        builder.providerId(group.getId());
        builder.name(group.getName());
        builder.ownerId(group.getAccount());
        builder.ipPermissions(Iterables.transform(group.getIngressRules(), this.ruleToPermission));
        return builder.build();
    }
}

