/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.oauth.v2;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import java.io.Closeable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.OAuthFallbacks;
import org.jclouds.oauth.v2.config.Authorization;
import org.jclouds.oauth.v2.domain.Claims;
import org.jclouds.oauth.v2.domain.ClientCredentialsClaims;
import org.jclouds.oauth.v2.domain.Token;
import org.jclouds.oauth.v2.functions.ClaimsToAssertion;
import org.jclouds.oauth.v2.functions.ClientCredentialsClaimsToAssertion;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.ParamParser;

@Endpoint(value=Authorization.class)
public interface AuthorizationApi
extends Closeable {
    @Named(value="oauth2:authorize")
    @POST
    @FormParams(keys={"grant_type"}, values={"urn:ietf:params:oauth:grant-type:jwt-bearer"})
    @Consumes(value={"application/json"})
    @Fallback(value=OAuthFallbacks.AuthorizationExceptionOn4xx.class)
    public Token authorize(@FormParam(value="assertion") @ParamParser(value=ClaimsToAssertion.class) Claims var1);

    @Named(value="oauth2:authorize_client_secret")
    @POST
    @FormParams(keys={"grant_type"}, values={"client_credentials"})
    @Consumes(value={"application/json"})
    @Fallback(value=OAuthFallbacks.AuthorizationExceptionOn4xx.class)
    public Token authorizeClientSecret(@FormParam(value="client_id") String var1, @FormParam(value="client_secret") String var2, @FormParam(value="resource") String var3, @FormParam(value="scope") @Nullable String var4);

    @Named(value="oauth2:authorize_client_p12")
    @POST
    @FormParams(keys={"grant_type", "client_assertion_type"}, values={"client_credentials", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"})
    @Consumes(value={"application/json"})
    @Fallback(value=OAuthFallbacks.AuthorizationExceptionOn4xx.class)
    public Token authorize(@FormParam(value="client_id") String var1, @FormParam(value="client_assertion") @ParamParser(value=ClientCredentialsClaimsToAssertion.class) ClientCredentialsClaims var2, @FormParam(value="resource") String var3, @FormParam(value="scope") @Nullable String var4);
}

