/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.v1.features;

import com.google.common.annotations.Beta;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.swift.v1.binders.BindMetadataToHeaders;
import org.jclouds.openstack.swift.v1.binders.BindToHeaders;
import org.jclouds.openstack.swift.v1.domain.DeleteStaticLargeObjectResponse;
import org.jclouds.openstack.swift.v1.domain.Segment;
import org.jclouds.openstack.swift.v1.functions.ETagHeader;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/{objectName}")
@Beta
public interface StaticLargeObjectApi {
    @Named(value="staticLargeObject:replaceManifest")
    @PUT
    @ResponseParser(value=ETagHeader.class)
    @QueryParams(keys={"multipart-manifest"}, values={"put"})
    public String replaceManifest(@PathParam(value="objectName") String var1, @BinderParam(value=BindToJsonPayload.class) List<Segment> var2, @BinderParam(value=BindMetadataToHeaders.BindObjectMetadataToHeaders.class) Map<String, String> var3);

    @Named(value="staticLargeObject:replaceManifest")
    @PUT
    @ResponseParser(value=ETagHeader.class)
    @QueryParams(keys={"multipart-manifest"}, values={"put"})
    public String replaceManifest(@PathParam(value="objectName") String var1, @BinderParam(value=BindToJsonPayload.class) List<Segment> var2, @BinderParam(value=BindMetadataToHeaders.BindObjectMetadataToHeaders.class) Map<String, String> var3, @BinderParam(value=BindToHeaders.class) Map<String, String> var4);

    @Named(value="staticLargeObject:delete")
    @DELETE
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    @QueryParams(keys={"multipart-manifest"}, values={"delete"})
    public DeleteStaticLargeObjectResponse delete(@PathParam(value="objectName") String var1);

    @Named(value="staticLargeObject:getManifest")
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    @QueryParams(keys={"format", "multipart-manifest"}, values={"json", "get"})
    public List<Segment> getManifest(@PathParam(value="objectName") String var1);
}

