/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.hash.HashCode;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.Map;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.crypto.Crypto;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.io.Payload;
import org.jclouds.location.Provider;
import org.jclouds.s3.filters.Aws4SignerBase;
import org.jclouds.s3.filters.ChunkedUploadException;
import org.jclouds.s3.filters.ChunkedUploadPayload;
import org.jclouds.util.Strings2;

public class Aws4SignerForChunkedUpload
extends Aws4SignerBase {
    private final int userDataBlockSize;

    @Inject
    public Aws4SignerForChunkedUpload(SignatureWire signatureWire, @Named(value="jclouds.aws.header.tag") String headerTag, @Named(value="jclouds.s3.chunked.size") int userDataBlockSize, @Provider Supplier<Credentials> creds, @TimeStamp Supplier<Date> timestampProvider, Aws4SignerBase.ServiceAndRegion serviceAndRegion, Crypto crypto) {
        super(signatureWire, headerTag, creds, timestampProvider, serviceAndRegion, crypto);
        this.userDataBlockSize = userDataBlockSize;
    }

    protected HttpRequest sign(HttpRequest request) throws HttpException {
        String signature;
        ByteProcessor<byte[]> hmacSHA256;
        String contentType;
        HashCode md5;
        Preconditions.checkNotNull((Object)request, (Object)"request is not ready to sign");
        Preconditions.checkNotNull((Object)request.getEndpoint(), (Object)"request is not ready to sign, request.endpoint not present.");
        Payload payload = request.getPayload();
        Long contentLength = payload.getContentMetadata().getContentLength();
        Preconditions.checkNotNull((Object)contentLength, (Object)"request is not ready to sign, payload contentLength not present.");
        String host = request.getEndpoint().getHost();
        Date date = (Date)this.timestampProvider.get();
        String timestamp = this.timestampFormat.format(date);
        String datestamp = this.dateFormat.format(date);
        String service = this.serviceAndRegion.service();
        String region = this.serviceAndRegion.region(host);
        String credentialScope = Joiner.on((char)'/').join((Object)datestamp, (Object)region, new Object[]{service, "aws4_request"});
        HttpRequest.Builder requestBuilder = (HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)request.toBuilder().removeHeader("Authorization")).removeHeader("Date")).removeHeader("Content-Length");
        ImmutableSortedMap.Builder signedHeadersBuilder = ImmutableSortedMap.naturalOrder();
        Object contentEncoding = "aws-chunked";
        String originalContentEncoding = payload.getContentMetadata().getContentEncoding();
        if (originalContentEncoding != null) {
            contentEncoding = (String)contentEncoding + "," + originalContentEncoding;
        }
        requestBuilder.replaceHeader("Content-Encoding", new String[]{contentEncoding});
        signedHeadersBuilder.put((Object)"Content-Encoding".toLowerCase(), contentEncoding);
        requestBuilder.replaceHeader("x-amz-decoded-content-length", new String[]{contentLength.toString()});
        signedHeadersBuilder.put((Object)"x-amz-decoded-content-length".toLowerCase(), (Object)contentLength.toString());
        long totalLength = Aws4SignerForChunkedUpload.calculateChunkedContentLength(contentLength, this.userDataBlockSize);
        requestBuilder.replaceHeader("Content-Length", new String[]{Long.toString(totalLength)});
        signedHeadersBuilder.put((Object)"Content-Length".toLowerCase(), (Object)Long.toString(totalLength));
        String contentMD5 = request.getFirstHeaderOrNull("Content-MD5");
        if (payload != null && (md5 = payload.getContentMetadata().getContentMD5AsHashCode()) != null) {
            contentMD5 = BaseEncoding.base64().encode(md5.asBytes());
        }
        if (contentMD5 != null) {
            requestBuilder.replaceHeader("Content-MD5", new String[]{contentMD5});
            signedHeadersBuilder.put((Object)"Content-MD5".toLowerCase(), (Object)contentMD5);
        }
        if (!Strings.isNullOrEmpty((String)(contentType = this.getContentType(request)))) {
            requestBuilder.replaceHeader("Content-Type", new String[]{contentType});
            signedHeadersBuilder.put((Object)"Content-Type".toLowerCase(), (Object)contentType);
        } else {
            requestBuilder.removeHeader("Content-Type");
        }
        host = Aws4SignerForChunkedUpload.hostHeaderFor(request.getEndpoint());
        requestBuilder.replaceHeader("Host", new String[]{host});
        signedHeadersBuilder.put((Object)"Host".toLowerCase(), (Object)host);
        String userAgent = request.getFirstHeaderOrNull("User-Agent");
        if (userAgent != null) {
            signedHeadersBuilder.put((Object)"User-Agent".toLowerCase(), (Object)userAgent);
        }
        this.appendAmzHeaders(request, (ImmutableMap.Builder<String, String>)signedHeadersBuilder);
        Credentials credentials = (Credentials)this.creds.get();
        if (credentials instanceof SessionCredentials) {
            String token = ((SessionCredentials)SessionCredentials.class.cast(credentials)).getSessionToken();
            requestBuilder.replaceHeader("X-Amz-Security-Token", new String[]{token});
            signedHeadersBuilder.put((Object)"X-Amz-Security-Token".toLowerCase(), (Object)token);
        }
        String contentSha256 = this.getPayloadHash();
        requestBuilder.replaceHeader("x-amz-content-sha256", new String[]{contentSha256});
        signedHeadersBuilder.put((Object)"x-amz-content-sha256".toLowerCase(), (Object)contentSha256);
        requestBuilder.replaceHeader("X-Amz-Date", new String[]{timestamp});
        signedHeadersBuilder.put((Object)"X-Amz-Date".toLowerCase(), (Object)timestamp);
        ImmutableMap signedHeaders = signedHeadersBuilder.build();
        String stringToSign = this.createStringToSign(request.getMethod(), request.getEndpoint(), (Map<String, String>)signedHeaders, timestamp, credentialScope, contentSha256);
        this.signatureWire.getWireLog().debug("<< " + stringToSign, new Object[0]);
        byte[] signatureKey = this.signatureKey(credentials.credential, datestamp, region, service);
        try {
            hmacSHA256 = Aws4SignerForChunkedUpload.hmacSHA256(this.crypto, signatureKey);
        }
        catch (InvalidKeyException e) {
            throw new ChunkedUploadException("invalid key", e);
        }
        try {
            signature = Aws4SignerForChunkedUpload.hex((byte[])ByteStreams.readBytes((InputStream)Strings2.toInputStream((String)stringToSign), hmacSHA256));
        }
        catch (IOException e) {
            throw new ChunkedUploadException("hmac sha256 seed signature error", e);
        }
        StringBuilder authorization = new StringBuilder("AWS4-HMAC-SHA256").append(" ");
        authorization.append("Credential=").append(Joiner.on((String)"/").join((Object)credentials.identity, (Object)credentialScope, new Object[0])).append(", ");
        authorization.append("SignedHeaders=").append(Joiner.on((String)";").join((Iterable)signedHeaders.keySet())).append(", ");
        authorization.append("Signature=").append(signature);
        ChunkedUploadPayload chunkedPayload = new ChunkedUploadPayload(payload, this.userDataBlockSize, timestamp, credentialScope, hmacSHA256, signature);
        chunkedPayload.getContentMetadata().setContentEncoding(null);
        return ((HttpRequest.Builder)((HttpRequest.Builder)requestBuilder.replaceHeader("Authorization", new String[]{authorization.toString()})).payload((Payload)chunkedPayload)).build();
    }

    protected String getPayloadHash() {
        return "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    }

    public static long calculateChunkedContentLength(long originalLength, long chunkSize) {
        Preconditions.checkArgument((originalLength > 0L ? 1 : 0) != 0, (Object)"Nonnegative content length expected.");
        long maxSizeChunks = originalLength / chunkSize;
        long remainingBytes = originalLength % chunkSize;
        return maxSizeChunks * Aws4SignerForChunkedUpload.calculateChunkHeaderLength(chunkSize) + (remainingBytes > 0L ? Aws4SignerForChunkedUpload.calculateChunkHeaderLength(remainingBytes) : 0L) + Aws4SignerForChunkedUpload.calculateChunkHeaderLength(0L);
    }

    private static long calculateChunkHeaderLength(long chunkDataSize) {
        return (long)(Long.toHexString(chunkDataSize).length() + ";chunk-signature=".length() + 64 + "\r\n".length()) + chunkDataSize + (long)"\r\n".length();
    }
}

