/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import org.jclouds.http.internal.PayloadEnclosingImpl;
import org.jclouds.io.Payload;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.MutableObjectMetadata;
import org.jclouds.s3.domain.S3Object;

public class S3ObjectImpl
extends PayloadEnclosingImpl
implements S3Object,
Comparable<S3Object> {
    private AccessControlList accessControlList;
    private final MutableObjectMetadata metadata;
    private Multimap<String, String> allHeaders = LinkedHashMultimap.create();

    @Override
    public void setAccessControlList(AccessControlList acl) {
        this.accessControlList = acl;
    }

    @Override
    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    @Inject
    public S3ObjectImpl(MutableObjectMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public MutableObjectMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public Multimap<String, String> getAllHeaders() {
        return this.allHeaders;
    }

    @Override
    public void setAllHeaders(Multimap<String, String> allHeaders) {
        this.allHeaders = (Multimap)Preconditions.checkNotNull(allHeaders, (Object)"allHeaders");
    }

    @Override
    public int compareTo(S3Object o) {
        if (this.getMetadata().getKey() == null) {
            return -1;
        }
        return this == o ? 0 : this.getMetadata().getKey().compareTo(o.getMetadata().getKey());
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        S3ObjectImpl other = (S3ObjectImpl)obj;
        return !(this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata));
    }

    public String toString() {
        return "[metadata=" + String.valueOf(this.metadata) + "]";
    }

    public void setPayload(Payload data) {
        super.setPayload(data);
        this.metadata.setContentMetadata(data.getContentMetadata());
    }
}

