/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.io.Payload;
import org.jclouds.s3.blobstore.functions.BlobToObjectMetadata;
import org.jclouds.s3.domain.S3Object;

@Singleton
public class BlobToObject
implements Function<Blob, S3Object> {
    private final BlobToObjectMetadata blob2ObjectMd;
    private final S3Object.Factory objectProvider;

    @Inject
    BlobToObject(BlobToObjectMetadata blob2ObjectMd, S3Object.Factory objectProvider) {
        this.blob2ObjectMd = blob2ObjectMd;
        this.objectProvider = objectProvider;
    }

    public S3Object apply(Blob from) {
        if (from == null) {
            return null;
        }
        S3Object object = this.objectProvider.create(this.blob2ObjectMd.apply((BlobMetadata)from.getMetadata()));
        object.setPayload((Payload)Preconditions.checkNotNull((Object)from.getPayload(), (Object)("payload: " + String.valueOf(from))));
        object.setAllHeaders((Multimap<String, String>)from.getAllHeaders());
        return object;
    }
}

