/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Throwables;
import jakarta.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.binders.XMLHelper;
import org.jclouds.s3.domain.PublicAccessBlockConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public final class BindPublicAccessBlockConfigurationToXMLPayload
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        PublicAccessBlockConfiguration configuration = (PublicAccessBlockConfiguration)payload;
        try {
            request.setPayload(this.generatePayload(configuration));
            request.getPayload().getContentMetadata().setContentType("text/xml");
            return request;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new RuntimeException("error transforming configuration: " + String.valueOf(configuration), e);
        }
    }

    protected String generatePayload(PublicAccessBlockConfiguration configuration) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        Document document = XMLHelper.createDocument();
        Element rootNode = XMLHelper.elem(document, "PublicAccessBlockConfiguration", document);
        rootNode.setAttribute("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        XMLHelper.elemWithText(rootNode, "BlockPublicAcls", String.valueOf(configuration.blockPublicAcls()), document);
        XMLHelper.elemWithText(rootNode, "IgnorePublicAcls", String.valueOf(configuration.ignorePublicAcls()), document);
        XMLHelper.elemWithText(rootNode, "BlockPublicPolicy", String.valueOf(configuration.blockPublicPolicy()), document);
        XMLHelper.elemWithText(rootNode, "RestrictPublicBuckets", String.valueOf(configuration.restrictPublicBuckets()), document);
        return XMLHelper.asString(document);
    }
}

