/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Throwables;
import jakarta.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.binders.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
public final class BindOwnershipControlsToXMLPayload
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        String from = (String)payload;
        try {
            request.setPayload(this.generatePayload(from));
            request.getPayload().getContentMetadata().setContentType("text/xml");
            return request;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e);
            throw new RuntimeException("error transforming acl: " + from, e);
        }
    }

    protected String generatePayload(String objectOwnership) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        Document document = XMLHelper.createDocument();
        Element rootNode = XMLHelper.elem(document, "OwnershipControls", document);
        rootNode.setAttribute("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        Element ruleNode = XMLHelper.elem(rootNode, "Rule", document);
        XMLHelper.elemWithText(ruleNode, "ObjectOwnership", objectOwnership, document);
        return XMLHelper.asString(document);
    }
}

