/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3;

import com.google.common.annotations.Beta;
import com.google.inject.Provides;
import jakarta.inject.Named;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.blobstore.BlobStoreFallbacks;
import org.jclouds.blobstore.attr.BlobScope;
import org.jclouds.blobstore.attr.BlobScopes;
import org.jclouds.http.functions.ParseETagHeader;
import org.jclouds.http.options.GetOptions;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.s3.Bucket;
import org.jclouds.s3.S3Fallbacks;
import org.jclouds.s3.binders.BindACLToXMLPayload;
import org.jclouds.s3.binders.BindAsHostPrefixIfConfigured;
import org.jclouds.s3.binders.BindBucketLoggingToXmlPayload;
import org.jclouds.s3.binders.BindCannedAclToRequest;
import org.jclouds.s3.binders.BindIterableAsPayloadToDeleteRequest;
import org.jclouds.s3.binders.BindNoBucketLoggingToXmlPayload;
import org.jclouds.s3.binders.BindObjectMetadataToRequest;
import org.jclouds.s3.binders.BindOwnershipControlsToXMLPayload;
import org.jclouds.s3.binders.BindPartIdsAndETagsToRequest;
import org.jclouds.s3.binders.BindPayerToXmlPayload;
import org.jclouds.s3.binders.BindPublicAccessBlockConfigurationToXMLPayload;
import org.jclouds.s3.binders.BindS3ObjectMetadataToRequest;
import org.jclouds.s3.domain.AccessControlList;
import org.jclouds.s3.domain.BucketLogging;
import org.jclouds.s3.domain.BucketMetadata;
import org.jclouds.s3.domain.CannedAccessPolicy;
import org.jclouds.s3.domain.DeleteResult;
import org.jclouds.s3.domain.ListBucketResponse;
import org.jclouds.s3.domain.ListMultipartUploadResponse;
import org.jclouds.s3.domain.ListMultipartUploadsResponse;
import org.jclouds.s3.domain.ObjectMetadata;
import org.jclouds.s3.domain.Payer;
import org.jclouds.s3.domain.PublicAccessBlockConfiguration;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.fallbacks.FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.jclouds.s3.functions.AssignCorrectHostnameForBucket;
import org.jclouds.s3.functions.BindRegionToXmlPayload;
import org.jclouds.s3.functions.DefaultEndpointThenInvalidateRegion;
import org.jclouds.s3.functions.ETagFromHttpResponseViaRegex;
import org.jclouds.s3.functions.ObjectKey;
import org.jclouds.s3.functions.ObjectMetadataKey;
import org.jclouds.s3.functions.ParseObjectFromHeadersAndHttpContent;
import org.jclouds.s3.functions.ParseObjectMetadataFromHeaders;
import org.jclouds.s3.functions.UploadIdFromHttpResponseViaRegex;
import org.jclouds.s3.options.CopyObjectOptions;
import org.jclouds.s3.options.ListBucketOptions;
import org.jclouds.s3.options.PutBucketOptions;
import org.jclouds.s3.options.PutObjectOptions;
import org.jclouds.s3.predicates.validators.BucketNameValidator;
import org.jclouds.s3.xml.AccessControlListHandler;
import org.jclouds.s3.xml.BucketLoggingHandler;
import org.jclouds.s3.xml.CopyObjectHandler;
import org.jclouds.s3.xml.DeleteResultHandler;
import org.jclouds.s3.xml.ListAllMyBucketsHandler;
import org.jclouds.s3.xml.ListBucketHandler;
import org.jclouds.s3.xml.ListMultipartUploadsHandler;
import org.jclouds.s3.xml.LocationConstraintHandler;
import org.jclouds.s3.xml.PartIdsFromHttpResponse;
import org.jclouds.s3.xml.PartIdsFromHttpResponseFull;
import org.jclouds.s3.xml.PayerHandler;

@RequestFilters(value={RequestAuthorizeSignature.class})
@BlobScope(value=BlobScopes.CONTAINER)
public interface S3Client
extends Closeable {
    @Provides
    public S3Object newS3Object();

    @Named(value="GetObject")
    @GET
    @Path(value="/{key}")
    @Fallback(value=BlobStoreFallbacks.NullOnKeyNotFound.class)
    @ResponseParser(value=ParseObjectFromHeadersAndHttpContent.class)
    public S3Object getObject(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, GetOptions ... var3);

    @Named(value="GetObject")
    @HEAD
    @Path(value="/{key}")
    @Fallback(value=BlobStoreFallbacks.NullOnKeyNotFound.class)
    @ResponseParser(value=ParseObjectMetadataFromHeaders.class)
    public ObjectMetadata headObject(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @Named(value="GetObject")
    @HEAD
    @Path(value="/{key}")
    @Fallback(value=BlobStoreFallbacks.FalseOnKeyNotFound.class)
    public boolean objectExists(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @Named(value="DeleteObject")
    @DELETE
    @Path(value="/{key}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteObject(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @Named(value="DeleteObject")
    @POST
    @Path(value="/")
    @QueryParams(keys={"delete"})
    @XMLResponseParser(value=DeleteResultHandler.class)
    public DeleteResult deleteObjects(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindIterableAsPayloadToDeleteRequest.class) Iterable<String> var2);

    @Named(value="PutObject")
    @PUT
    @Path(value="/{key}")
    @Headers(keys={"Expect"}, values={"100-continue"})
    @ResponseParser(value=ParseETagHeader.class)
    public String putObject(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") @ParamParser(value=ObjectKey.class) @BinderParam(value=BindS3ObjectMetadataToRequest.class) S3Object var2, PutObjectOptions ... var3);

    @Named(value="CreateBucket")
    @PUT
    @Path(value="/")
    @Endpoint(value=Bucket.class)
    @Fallback(value=FalseIfBucketAlreadyOwnedByYouOrOperationAbortedWhenBucketExists.class)
    public boolean putBucketInRegion(@BinderParam(value=BindRegionToXmlPayload.class) @Nullable String var1, @Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var2, PutBucketOptions ... var3);

    @Named(value="DeleteBucket")
    @DELETE
    @Path(value="/")
    @Fallback(value=S3Fallbacks.TrueOn404OrNotFoundFalseOnIllegalState.class)
    public boolean deleteBucketIfEmpty(@Bucket @EndpointParam(parser=DefaultEndpointThenInvalidateRegion.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="BucketExists")
    @HEAD
    @Path(value="/")
    @Fallback(value=BlobStoreFallbacks.FalseOnContainerNotFound.class)
    public boolean bucketExists(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="ListBucket")
    @GET
    @Path(value="/")
    @XMLResponseParser(value=ListBucketHandler.class)
    public ListBucketResponse listBucket(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, ListBucketOptions ... var2);

    @Named(value="ListAllMyBuckets")
    @GET
    @XMLResponseParser(value=ListAllMyBucketsHandler.class)
    @Path(value="/")
    @VirtualHost
    public Set<BucketMetadata> listOwnedBuckets();

    @Named(value="PutObject")
    @PUT
    @Path(value="/{destinationObject}")
    @Headers(keys={"x-amz-copy-source"}, values={"/{sourceBucket}/{sourceObject}"}, urlEncode={true})
    @XMLResponseParser(value=CopyObjectHandler.class)
    public ObjectMetadata copyObject(@PathParam(value="sourceBucket") String var1, @PathParam(value="sourceObject") String var2, @Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var3, @PathParam(value="destinationObject") String var4, CopyObjectOptions ... var5);

    @Named(value="GetBucketAcl")
    @GET
    @QueryParams(keys={"acl"})
    @XMLResponseParser(value=AccessControlListHandler.class)
    @Fallback(value=BlobStoreFallbacks.ThrowContainerNotFoundOn404.class)
    @Path(value="/")
    public AccessControlList getBucketACL(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="PutBucketAcl")
    @PUT
    @Path(value="/")
    @QueryParams(keys={"acl"})
    public boolean putBucketACL(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindACLToXMLPayload.class) AccessControlList var2);

    @Named(value="UpdateBucketCannedAcl")
    @PUT
    @Path(value="/")
    @QueryParams(keys={"acl"})
    public boolean updateBucketCannedACL(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindCannedAclToRequest.class) CannedAccessPolicy var2);

    @Named(value="GetObjectAcl")
    @GET
    @QueryParams(keys={"acl"})
    @Path(value="/{key}")
    @XMLResponseParser(value=AccessControlListHandler.class)
    @Fallback(value=BlobStoreFallbacks.ThrowKeyNotFoundOn404.class)
    public AccessControlList getObjectACL(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2);

    @Named(value="PutObjectAcl")
    @PUT
    @QueryParams(keys={"acl"})
    @Path(value="/{key}")
    public boolean putObjectACL(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @BinderParam(value=BindACLToXMLPayload.class) AccessControlList var3);

    @Named(value="UpdateObjectCannedAcl")
    @PUT
    @QueryParams(keys={"acl"})
    @Path(value="/{key}")
    public boolean updateObjectCannedACL(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @BinderParam(value=BindCannedAclToRequest.class) CannedAccessPolicy var3);

    @Named(value="GetBucketLocation")
    @GET
    @QueryParams(keys={"location"})
    @Path(value="/{bucket}")
    @Endpoint(value=Bucket.class)
    @XMLResponseParser(value=LocationConstraintHandler.class)
    public String getBucketLocation(@Bucket @PathParam(value="bucket") @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="GetBucketRequestPayment")
    @GET
    @QueryParams(keys={"requestPayment"})
    @Path(value="/")
    @XMLResponseParser(value=PayerHandler.class)
    public Payer getBucketPayer(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="PutBucketRequestPayment")
    @PUT
    @QueryParams(keys={"requestPayment"})
    @Path(value="/")
    public void setBucketPayer(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindPayerToXmlPayload.class) Payer var2);

    @Named(value="GetBucketLogging")
    @GET
    @QueryParams(keys={"logging"})
    @XMLResponseParser(value=BucketLoggingHandler.class)
    @Fallback(value=BlobStoreFallbacks.ThrowContainerNotFoundOn404.class)
    @Path(value="/")
    public BucketLogging getBucketLogging(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="PutBucketLogging")
    @PUT
    @Path(value="/")
    @QueryParams(keys={"logging"})
    public void enableBucketLogging(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindBucketLoggingToXmlPayload.class) BucketLogging var2);

    @Named(value="PutBucketLogging")
    @PUT
    @Path(value="/")
    @QueryParams(keys={"logging"})
    @Produces(value={"text/xml"})
    public void disableBucketLogging(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindNoBucketLoggingToXmlPayload.class) @ParamValidators(value={BucketNameValidator.class}) String var1);

    @Named(value="PutObject")
    @POST
    @QueryParams(keys={"uploads"})
    @Path(value="/{key}")
    @ResponseParser(value=UploadIdFromHttpResponseViaRegex.class)
    public String initiateMultipartUpload(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") @ParamParser(value=ObjectMetadataKey.class) @BinderParam(value=BindObjectMetadataToRequest.class) ObjectMetadata var2, PutObjectOptions ... var3);

    @Named(value="AbortMultipartUpload")
    @DELETE
    @Path(value="/{key}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void abortMultipartUpload(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @QueryParam(value="uploadId") String var3);

    @Named(value="PutObject")
    @PUT
    @Path(value="/{key}")
    @ResponseParser(value=ParseETagHeader.class)
    public String uploadPart(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @QueryParam(value="partNumber") int var3, @QueryParam(value="uploadId") String var4, Payload var5);

    @Named(value="UploadPartCopy")
    @PUT
    @Path(value="/{key}")
    @Headers(keys={"x-amz-copy-source", "x-amz-copy-source-range"}, values={"/{sourceBucket}/{sourceObject}", "bytes={startOffset}-{endOffset}"}, urlEncode={true, false})
    @ResponseParser(value=ETagFromHttpResponseViaRegex.class)
    public String uploadPartCopy(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @QueryParam(value="partNumber") int var3, @QueryParam(value="uploadId") String var4, @PathParam(value="sourceBucket") String var5, @PathParam(value="sourceObject") String var6, @PathParam(value="startOffset") long var7, @PathParam(value="endOffset") long var9);

    @Named(value="PutObject")
    @POST
    @Path(value="/{key}")
    @ResponseParser(value=ETagFromHttpResponseViaRegex.class)
    public String completeMultipartUpload(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @QueryParam(value="uploadId") String var3, @BinderParam(value=BindPartIdsAndETagsToRequest.class) Map<Integer, String> var4);

    @Deprecated
    @Named(value="ListMultipartParts")
    @GET
    @Path(value="/{key}")
    @XMLResponseParser(value=PartIdsFromHttpResponse.class)
    public Map<Integer, String> listMultipartParts(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @QueryParam(value="uploadId") String var3);

    @Named(value="ListMultipartParts")
    @GET
    @Path(value="/{key}")
    @XMLResponseParser(value=PartIdsFromHttpResponseFull.class)
    @Beta
    public Map<Integer, ListMultipartUploadResponse> listMultipartPartsFull(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @PathParam(value="key") String var2, @QueryParam(value="uploadId") String var3);

    @Named(value="ListMultipartUploads")
    @GET
    @Path(value="/")
    @QueryParams(keys={"uploads"})
    @XMLResponseParser(value=ListMultipartUploadsHandler.class)
    public ListMultipartUploadsResponse listMultipartUploads(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @QueryParam(value="delimiter") @Nullable String var2, @QueryParam(value="max-uploads") @Nullable Integer var3, @QueryParam(value="key-marker") @Nullable String var4, @QueryParam(value="prefix") @Nullable String var5, @QueryParam(value="upload-id-marker") @Nullable String var6);

    @Named(value="PutBucketOwnershipControls")
    @PUT
    @Path(value="/")
    @QueryParams(keys={"ownershipControls"})
    public void putBucketOwnershipControls(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindOwnershipControlsToXMLPayload.class) String var2);

    @Named(value="PutPublicAccessBlock")
    @PUT
    @Path(value="/")
    @QueryParams(keys={"publicAccessBlock"})
    public void putPublicAccessBlock(@Bucket @EndpointParam(parser=AssignCorrectHostnameForBucket.class) @BinderParam(value=BindAsHostPrefixIfConfigured.class) @ParamValidators(value={BucketNameValidator.class}) String var1, @BinderParam(value=BindPublicAccessBlockConfigurationToXMLPayload.class) PublicAccessBlockConfiguration var2);
}

