/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import com.google.common.collect.Multimap;
import jakarta.inject.Named;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.aws.ec2.binders.BindLaunchSpecificationToFormParams;
import org.jclouds.aws.ec2.domain.LaunchSpecification;
import org.jclouds.aws.ec2.domain.Spot;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.options.DescribeSpotPriceHistoryOptions;
import org.jclouds.aws.ec2.options.RequestSpotInstancesOptions;
import org.jclouds.aws.ec2.xml.DescribeSpotPriceHistoryResponseHandler;
import org.jclouds.aws.ec2.xml.SpotInstanceHandler;
import org.jclouds.aws.ec2.xml.SpotInstancesHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface SpotInstanceApi {
    @Named(value="DescribeSpotInstanceRequests")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSpotInstanceRequests"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=SpotInstancesHandler.class)
    public Set<SpotInstanceRequest> describeSpotInstanceRequestsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="DescribeSpotInstanceRequests")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSpotInstanceRequests"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    @XMLResponseParser(value=SpotInstancesHandler.class)
    public Set<SpotInstanceRequest> describeSpotInstanceRequestsInRegionWithFilter(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var2);

    @Named(value="RequestSpotInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RequestSpotInstances"})
    @XMLResponseParser(value=SpotInstanceHandler.class)
    public SpotInstanceRequest requestSpotInstanceInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="SpotPrice") float var2, @FormParam(value="LaunchSpecification.ImageId") String var3, @FormParam(value="LaunchSpecification.InstanceType") String var4);

    @Named(value="RequestSpotInstances")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RequestSpotInstances"})
    @XMLResponseParser(value=SpotInstancesHandler.class)
    public Set<SpotInstanceRequest> requestSpotInstancesInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="SpotPrice") float var2, @FormParam(value="InstanceCount") int var3, @BinderParam(value=BindLaunchSpecificationToFormParams.class) LaunchSpecification var4, RequestSpotInstancesOptions ... var5);

    @Named(value="DescribeSpotPriceHistory")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSpotPriceHistory"})
    @XMLResponseParser(value=DescribeSpotPriceHistoryResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<Spot> describeSpotPriceHistoryInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, DescribeSpotPriceHistoryOptions ... var2);

    @Named(value="CancelSpotInstanceRequests")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CancelSpotInstanceRequests"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void cancelSpotInstanceRequestsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);
}

