/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.features;

import jakarta.inject.Named;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Set;
import org.jclouds.aws.ec2.xml.ProductCodesHandler;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindProductCodesToIndexedFormParams;
import org.jclouds.ec2.features.AMIApi;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface AWSAMIApi
extends AMIApi {
    @Named(value="DescribeImageAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "Attribute"}, values={"DescribeImageAttribute", "productCodes"})
    @XMLResponseParser(value=ProductCodesHandler.class)
    public Set<String> getProductCodesForImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="ImageId") String var2);

    @Named(value="ModifyImageAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "OperationType", "Attribute"}, values={"ModifyImageAttribute", "add", "productCodes"})
    public void addProductCodesToImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindProductCodesToIndexedFormParams.class) Iterable<String> var2, @FormParam(value="ImageId") String var3);

    @Named(value="ModifyImageAttribute")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action", "OperationType", "Attribute"}, values={"ModifyImageAttribute", "remove", "productCodes"})
    public void removeProductCodesFromImageInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindProductCodesToIndexedFormParams.class) Iterable<String> var2, @FormParam(value="ImageId") String var3);
}

