/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.features.SpotInstanceApi;
import org.jclouds.aws.ec2.functions.SpotInstanceRequestToAWSRunningInstance;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.ec2.EC2Api;
import org.jclouds.ec2.compute.strategy.EC2GetNodeMetadataStrategy;
import org.jclouds.ec2.domain.RunningInstance;

@Singleton
public class AWSEC2GetNodeMetadataStrategy
extends EC2GetNodeMetadataStrategy {
    private final AWSEC2Api client;
    private final SpotInstanceRequestToAWSRunningInstance spotConverter;

    @Inject
    protected AWSEC2GetNodeMetadataStrategy(AWSEC2Api client, Function<RunningInstance, NodeMetadata> runningInstanceToNodeMetadata, SpotInstanceRequestToAWSRunningInstance spotConverter) {
        super((EC2Api)client, runningInstanceToNodeMetadata);
        this.client = (AWSEC2Api)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.spotConverter = (SpotInstanceRequestToAWSRunningInstance)Preconditions.checkNotNull((Object)spotConverter, (Object)"spotConverter");
    }

    public RunningInstance getRunningInstanceInRegion(String region, String id) {
        if (id.indexOf("sir-") != 0) {
            return super.getRunningInstanceInRegion(region, id);
        }
        SpotInstanceRequest spot = (SpotInstanceRequest)Iterables.getOnlyElement(((SpotInstanceApi)this.client.getSpotInstanceApi().get()).describeSpotInstanceRequestsInRegion(region, id));
        if (spot.getState() == SpotInstanceRequest.State.ACTIVE) {
            return super.getRunningInstanceInRegion(region, spot.getInstanceId());
        }
        return this.spotConverter.apply(spot);
    }
}

