/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.Subnet;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.FalseOn204;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/virtualNetworks/{virtualnetwork}/subnets")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface SubnetApi {
    @Named(value="subnet:list")
    @SelectJson(value={"value"})
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Subnet> list();

    @Named(value="subnet:create_or_update")
    @Path(value="/{subnetname}")
    @MapBinder(value=BindToJsonPayload.class)
    @PUT
    public Subnet createOrUpdate(@PathParam(value="subnetname") String var1, @PayloadParam(value="properties") Subnet.SubnetProperties var2);

    @Named(value="subnet:get")
    @Path(value="/{subnetname}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Subnet get(@PathParam(value="subnetname") String var1);

    @Named(value="subnet:delete")
    @Path(value="/{subnetname}")
    @DELETE
    @ResponseParser(value=FalseOn204.class)
    public boolean delete(@PathParam(value="subnetname") String var1);
}

