/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.Availability;
import org.jclouds.azurecompute.arm.domain.StorageService;
import org.jclouds.azurecompute.arm.domain.StorageServiceKeys;
import org.jclouds.azurecompute.arm.domain.StorageServiceUpdateParams;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.FalseOn204;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface StorageAccountApi {
    @Named(value="storageaccount:list")
    @Path(value="/resourcegroups/{resourceGroup}/providers/Microsoft.Storage/storageAccounts")
    @GET
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<StorageService> list();

    @Named(value="storageaccount:create")
    @Path(value="/resourcegroups/{resourceGroup}/providers/Microsoft.Storage/storageAccounts/{storageAccountName}")
    @ResponseParser(value=URIParser.class)
    @MapBinder(value=BindToJsonPayload.class)
    @PUT
    public URI create(@PathParam(value="storageAccountName") String var1, @PayloadParam(value="location") String var2, @Nullable @PayloadParam(value="tags") Map<String, String> var3, @PayloadParam(value="properties") Map<String, String> var4);

    @Named(value="CheckStorageAccountNameAvailability")
    @POST
    @Payload(value="%7B\"name\":\"{name}\",\"type\":\"Microsoft.Storage/storageAccounts\"%7D")
    @Path(value="/providers/Microsoft.Storage/checkNameAvailability")
    @Produces(value={"application/json"})
    public Availability isAvailable(@PayloadParam(value="name") String var1);

    @Named(value="storageaccountproperty:get")
    @GET
    @Path(value="/resourcegroups/{resourceGroup}/providers/Microsoft.Storage/storageAccounts/{storageAccountName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public StorageService get(@PathParam(value="storageAccountName") String var1);

    @Named(value="storageaccountkey:get")
    @POST
    @Path(value="/resourcegroups/{resourceGroup}/providers/Microsoft.Storage/storageAccounts/{storageAccountName}/listKeys")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public StorageServiceKeys getKeys(@PathParam(value="storageAccountName") String var1);

    @Named(value="RegenerateStorageAccountKeys")
    @POST
    @Payload(value="%7B\"keyName\":\"{keyName}\"%7D")
    @Path(value="/resourcegroups/{resourceGroup}/providers/Microsoft.Storage/storageAccounts/{storageAccount}/regenerateKey")
    @Produces(value={"application/json"})
    public StorageServiceKeys regenerateKeys(@PathParam(value="storageAccount") String var1, @PayloadParam(value="keyName") String var2);

    @Named(value="storageaccount:update")
    @PATCH
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/resourcegroups/{resourceGroup}/providers/Microsoft.Storage/storageAccounts/{storageAccountName}")
    public StorageServiceUpdateParams update(@PathParam(value="storageAccountName") String var1, @Nullable @PayloadParam(value="tags") Map<String, String> var2, @PayloadParam(value="properties") StorageServiceUpdateParams.StorageServiceUpdateProperties var3);

    @Named(value="storageaccount:delete")
    @DELETE
    @ResponseParser(value=FalseOn204.class)
    @Path(value="/resourcegroups/{resourceGroup}/providers/Microsoft.Storage/storageAccounts/{storageAccountName}")
    public boolean delete(@PathParam(value="storageAccountName") String var1);
}

