/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRule;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRuleProperties;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Network/networkSecurityGroups/{networksecuritygroup}")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface NetworkSecurityRuleApi {
    @Named(value="networksecurityrule:createOrUpdate")
    @Path(value="/securityRules/{networksecurityrulename}")
    @PUT
    @MapBinder(value=BindToJsonPayload.class)
    public NetworkSecurityRule createOrUpdate(@PathParam(value="networksecurityrulename") String var1, @PayloadParam(value="properties") NetworkSecurityRuleProperties var2);

    @Named(value="networksecurityrule:getDefaultRule")
    @Path(value="/defaultSecurityRules/{networksecurityrulename}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public NetworkSecurityRule getDefaultRule(@PathParam(value="networksecurityrulename") String var1);

    @Named(value="networksecurityrule:get")
    @Path(value="/securityRules/{networksecurityrulename}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public NetworkSecurityRule get(@PathParam(value="networksecurityrulename") String var1);

    @Named(value="networksecurityrule:delete")
    @Path(value="/securityRules/{networksecurityrulename}")
    @DELETE
    @ResponseParser(value=URIParser.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="networksecurityrulename") String var1);

    @Named(value="networksecuritygroup:list")
    @Path(value="/securityRules")
    @GET
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<NetworkSecurityRule> list();

    @Named(value="networksecuritygroup:listDefaultRules")
    @Path(value="/defaultSecurityRules")
    @GET
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<NetworkSecurityRule> listDefaultRules();
}

