/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.Image;
import org.jclouds.azurecompute.arm.domain.ImageProperties;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Compute/images")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface ImageApi {
    @Named(value="image:list")
    @SelectJson(value={"value"})
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Image> list();

    @Named(value="image:create_or_update")
    @PUT
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/{imageName}")
    public Image createOrUpdate(@PathParam(value="imageName") String var1, @PayloadParam(value="location") String var2, @PayloadParam(value="properties") ImageProperties var3);

    @Named(value="image:get")
    @Path(value="/{imageName}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Image get(@PathParam(value="imageName") String var1);

    @Named(value="image:delete")
    @Path(value="/{imageName}")
    @DELETE
    @ResponseParser(value=URIParser.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="imageName") String var1);
}

