/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.Alert;
import org.jclouds.azurecompute.arm.domain.AlertModification;
import org.jclouds.azurecompute.arm.domain.AlertSummary;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.options.AlertRequestOptions;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Path(value="/{resourceid}")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface AlertApi {
    @Named(value="alerts:getAll")
    @Path(value="/providers/Microsoft.AlertsManagement/alerts")
    @GET
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Alert> list(AlertRequestOptions ... var1);

    @Named(value="alerts:getbyid")
    @Path(value="/providers/Microsoft.AlertsManagement/alerts/{alertId}")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Alert get(@PathParam(value="alertId") String var1);

    @Named(value="alerts:changestate")
    @Path(value="/providers/Microsoft.AlertsManagement/alerts/{alertId}/changestate")
    @POST
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Alert changeState(@PathParam(value="alertId") String var1, @QueryParam(value="newState") String var2);

    @Named(value="alerts:history")
    @Path(value="/providers/Microsoft.AlertsManagement/alerts/{alertId}/history")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public AlertModification getHistory(@PathParam(value="alertId") String var1);

    @Named(value="alerts:summary")
    @Path(value="providers/Microsoft.AlertsManagement/alertsSummary")
    @GET
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public AlertSummary getSummary(AlertRequestOptions ... var1);
}

