/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.ActivityLogAlert;
import org.jclouds.azurecompute.arm.domain.ActivityLogAlertProperties;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Insights/activityLogAlerts")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface ActivityLogAlertApi {
    @Named(value="activitylogalert:get")
    @GET
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public ActivityLogAlert get(@PathParam(value="name") String var1);

    @Named(value="activitylogalert:list")
    @GET
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<ActivityLogAlert> list();

    @Named(value="activitylogalert:createOrUpdate")
    @PUT
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/{activityLogAlertName}")
    @QueryParams(keys={"validating"}, values={"false"})
    public ActivityLogAlert createOrUpdate(@PathParam(value="activityLogAlertName") String var1, @PayloadParam(value="properties") ActivityLogAlertProperties var2, @PayloadParam(value="tags") Map<String, String> var3, @PayloadParam(value="location") String var4);

    @Named(value="activitylogalert:delete")
    @DELETE
    @Path(value="/{activityLogAlertName}")
    @ResponseParser(value=URIParser.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="activityLogAlertName") String var1);
}

