/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain.vpn;

import com.google.auto.value.AutoValue;
import org.jclouds.azurecompute.arm.domain.vpn.AutoValue_SKU;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class SKU {
    public abstract int capacity();

    public abstract SKUName name();

    public abstract SKUTier tier();

    SKU() {
    }

    @SerializedNames(value={"capacity", "name", "tier"})
    public static SKU create(int capacity, SKUName name, SKUTier tier) {
        return new AutoValue_SKU(capacity, name, tier);
    }

    public static enum SKUName {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
        VpnGw1,
        VpnGw2,
        VpnGw3,
        Unrecognized;


        public static SKUName fromValue(String text) {
            return (SKUName)GetEnumValue.fromValueOrDefault(text, Unrecognized);
        }
    }

    public static enum SKUTier {
        Basic,
        HighPerformance,
        Standard,
        UltraPerformance,
        VpnGw1,
        VpnGw2,
        VpnGw3,
        Unrecognized;


        public static SKUTier fromValue(String text) {
            return (SKUTier)GetEnumValue.fromValueOrDefault(text, Unrecognized);
        }
    }
}

