/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain.publicipaddress;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.publicipaddress.AutoValue_PublicIPAddress;
import org.jclouds.azurecompute.arm.domain.publicipaddress.AutoValue_PublicIPAddress_SKU;
import org.jclouds.azurecompute.arm.domain.publicipaddress.PublicIPAddressProperties;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class PublicIPAddress {
    public abstract String name();

    public abstract String id();

    public abstract String etag();

    public abstract String location();

    @Nullable
    public abstract Map<String, String> tags();

    public abstract PublicIPAddressProperties properties();

    @Nullable
    public abstract SKU sku();

    @SerializedNames(value={"name", "id", "etag", "location", "tags", "sku", "properties"})
    public static PublicIPAddress create(String name, String id, String etag, String location, Map<String, String> tags, SKU sku, PublicIPAddressProperties properties) {
        return PublicIPAddress.builder().name(name).id(id).etag(etag).location(location).tags(tags).sku(sku).properties(properties).build();
    }

    PublicIPAddress() {
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_PublicIPAddress.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder name(String var1);

        public abstract Builder id(String var1);

        public abstract Builder etag(String var1);

        public abstract Builder location(String var1);

        public abstract Builder tags(Map<String, String> var1);

        public abstract Builder properties(PublicIPAddressProperties var1);

        public abstract Builder sku(SKU var1);

        abstract Map<String, String> tags();

        abstract PublicIPAddress autoBuild();

        public PublicIPAddress build() {
            this.tags((Map<String, String>)(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : null));
            return this.autoBuild();
        }
    }

    @AutoValue
    public static abstract class SKU {
        public abstract SKUName name();

        @SerializedNames(value={"name"})
        public static SKU create(SKUName name) {
            return new AutoValue_PublicIPAddress_SKU(name);
        }

        public static enum SKUName {
            Basic,
            Standard,
            Unrecognized;


            public static SKUName fromValue(String text) {
                return (SKUName)GetEnumValue.fromValueOrDefault(text, Unrecognized);
            }
        }
    }
}

