/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_ServicePrincipal;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class ServicePrincipal {
    @Nullable
    public abstract String appId();

    @Nullable
    public abstract Date deletionTimestamp();

    @Nullable
    public abstract String displayName();

    public abstract String objectId();

    public abstract String objectType();

    public abstract List<String> servicePrincipalNames();

    @SerializedNames(value={"appId", "deletionTimestamp", "displayName", "objectId", "objectType", "servicePrincipalNames"})
    public static ServicePrincipal create(String appId, Date deletionTimestamp, String displayName, String objectId, String objectType, List<String> servicePrincipalNames) {
        ImmutableList servicePrincipals = servicePrincipalNames != null ? ImmutableList.copyOf(servicePrincipalNames) : ImmutableList.of();
        return ServicePrincipal.builder().appId(appId).deletionTimestamp(deletionTimestamp).displayName(displayName).objectId(objectId).objectType(objectType).servicePrincipalNames((List<String>)servicePrincipals).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_ServicePrincipal.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder appId(String var1);

        public abstract Builder deletionTimestamp(Date var1);

        public abstract Builder displayName(String var1);

        public abstract Builder objectId(String var1);

        public abstract Builder objectType(String var1);

        public abstract Builder servicePrincipalNames(List<String> var1);

        public abstract ServicePrincipal build();
    }
}

