/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_NetworkSecurityGroupProperties;
import org.jclouds.azurecompute.arm.domain.NetworkInterfaceCard;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRule;
import org.jclouds.azurecompute.arm.domain.Provisionable;
import org.jclouds.azurecompute.arm.domain.Subnet;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class NetworkSecurityGroupProperties
implements Provisionable {
    @Nullable
    public abstract List<NetworkSecurityRule> securityRules();

    @Nullable
    public abstract List<NetworkSecurityRule> defaultSecurityRules();

    @Nullable
    public abstract List<NetworkInterfaceCard> networkInterfaces();

    @Nullable
    public abstract List<Subnet> subnets();

    @Nullable
    public abstract String resourceGuid();

    @Override
    @Nullable
    public abstract String provisioningState();

    @SerializedNames(value={"securityRules", "defaultSecurityRules", "networkInterfaces", "subnets", "resourceGuid", "provisioningState"})
    public static NetworkSecurityGroupProperties create(List<NetworkSecurityRule> securityRules, List<NetworkSecurityRule> defaultSecurityRules, List<NetworkInterfaceCard> networkInterfaces, List<Subnet> subnets, String resourceGuid, String provisioningState) {
        return NetworkSecurityGroupProperties.builder().securityRules((List<NetworkSecurityRule>)(securityRules == null ? null : ImmutableList.copyOf(securityRules))).defaultSecurityRules((List<NetworkSecurityRule>)(defaultSecurityRules == null ? null : ImmutableList.copyOf(defaultSecurityRules))).networkInterfaces((List<NetworkInterfaceCard>)(networkInterfaces == null ? null : ImmutableList.copyOf(networkInterfaces))).subnets((List<Subnet>)(subnets == null ? null : ImmutableList.copyOf(subnets))).resourceGuid(resourceGuid).provisioningState(provisioningState).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_NetworkSecurityGroupProperties.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder securityRules(List<NetworkSecurityRule> var1);

        public abstract Builder defaultSecurityRules(List<NetworkSecurityRule> var1);

        public abstract Builder networkInterfaces(List<NetworkInterfaceCard> var1);

        public abstract Builder subnets(List<Subnet> var1);

        public abstract Builder resourceGuid(String var1);

        public abstract Builder provisioningState(String var1);

        public abstract NetworkSecurityGroupProperties build();
    }
}

