/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.azurecompute.arm.domain.AutoValue_IdReference;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class IdReference {
    private static final Pattern RESOURCE_GROUP_PATTERN = Pattern.compile("^.*/resourceGroups/([^/]+)(/.*)?$");

    @Nullable
    public abstract String id();

    @Nullable
    public String resourceGroup() {
        return IdReference.extractResourceGroup(this.id());
    }

    @Nullable
    public String name() {
        return IdReference.extractName(this.id());
    }

    @SerializedNames(value={"id"})
    public static IdReference create(String id) {
        return new AutoValue_IdReference(id);
    }

    public static String extractName(String uri) {
        if (uri == null) {
            return null;
        }
        String noSlashAtEnd = uri.replaceAll("/+$", "");
        return noSlashAtEnd.substring(noSlashAtEnd.lastIndexOf(47) + 1);
    }

    public static String extractResourceGroup(String uri) {
        if (uri == null) {
            return null;
        }
        Matcher m = RESOURCE_GROUP_PATTERN.matcher(uri);
        return m.matches() ? m.group(1) : null;
    }
}

