/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.azurecompute.arm.domain.AutoValue_AvailabilitySet;
import org.jclouds.azurecompute.arm.domain.AutoValue_AvailabilitySet_AvailabilitySetProperties;
import org.jclouds.azurecompute.arm.domain.AutoValue_AvailabilitySet_SKU;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.Status;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class AvailabilitySet {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract String type();

    @Nullable
    public abstract String location();

    @Nullable
    public abstract SKU sku();

    @Nullable
    public abstract Map<String, String> tags();

    @Nullable
    public abstract AvailabilitySetProperties properties();

    @SerializedNames(value={"id", "name", "type", "location", "sku", "tags", "properties"})
    public static AvailabilitySet create(String id, String name, String type, String location, SKU sku, Map<String, String> tags, AvailabilitySetProperties properties) {
        return AvailabilitySet.builder().id(id).name(name).type(type).location(location).sku(sku).tags(tags).properties(properties).build();
    }

    public abstract Builder toBuilder();

    private static Builder builder() {
        return new AutoValue_AvailabilitySet.Builder();
    }

    public static Builder managed() {
        return AvailabilitySet.builder().managed();
    }

    public static Builder classic() {
        return AvailabilitySet.builder().classic();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder type(String var1);

        public abstract Builder location(String var1);

        public abstract Builder tags(Map<String, String> var1);

        public abstract Builder properties(AvailabilitySetProperties var1);

        abstract Builder sku(SKU var1);

        public Builder managed() {
            return this.sku(SKU.create(AvailabilitySetType.MANAGED));
        }

        public Builder classic() {
            return this.sku(SKU.create(AvailabilitySetType.CLASSIC));
        }

        abstract Map<String, String> tags();

        abstract AvailabilitySet autoBuild();

        public AvailabilitySet build() {
            this.tags((Map<String, String>)(this.tags() != null ? ImmutableMap.copyOf(this.tags()) : null));
            return this.autoBuild();
        }
    }

    @AutoValue
    public static abstract class SKU {
        public abstract AvailabilitySetType type();

        @SerializedNames(value={"name"})
        public static SKU create(String type) {
            return SKU.create(AvailabilitySetType.fromString(type));
        }

        public static SKU create(AvailabilitySetType type) {
            return new AutoValue_AvailabilitySet_SKU(type);
        }
    }

    @AutoValue
    public static abstract class AvailabilitySetProperties {
        public abstract int platformUpdateDomainCount();

        public abstract int platformFaultDomainCount();

        @Nullable
        public abstract List<IdReference> virtualMachines();

        @Nullable
        public abstract List<Status> statuses();

        @SerializedNames(value={"platformUpdateDomainCount", "platformFaultDomainCount", "virtualMachines", "statuses"})
        public static AvailabilitySetProperties create(int platformUpdateDomainCount, int platformFaultDomainCount, List<IdReference> virtualMachines, List<Status> statuses) {
            return AvailabilitySetProperties.builder().platformUpdateDomainCount(platformUpdateDomainCount).platformFaultDomainCount(platformFaultDomainCount).virtualMachines(virtualMachines).statuses(statuses).build();
        }

        public abstract Builder toBuilder();

        public static Builder builder() {
            return new AutoValue_AvailabilitySet_AvailabilitySetProperties.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder platformUpdateDomainCount(int var1);

            public abstract Builder platformFaultDomainCount(int var1);

            public abstract Builder virtualMachines(List<IdReference> var1);

            public abstract Builder statuses(List<Status> var1);

            abstract List<IdReference> virtualMachines();

            abstract List<Status> statuses();

            abstract AvailabilitySetProperties autoBuild();

            public AvailabilitySetProperties build() {
                this.virtualMachines((List<IdReference>)(this.virtualMachines() != null ? ImmutableList.copyOf(this.virtualMachines()) : null));
                this.statuses((List<Status>)(this.statuses() != null ? ImmutableList.copyOf(this.statuses()) : null));
                return this.autoBuild();
            }
        }
    }

    public static enum AvailabilitySetType {
        MANAGED("Aligned"),
        CLASSIC("Classic");

        private final String value;

        private AvailabilitySetType(String value) {
            this.value = value;
        }

        public static AvailabilitySetType fromString(String value) {
            AvailabilitySetType[] items;
            for (AvailabilitySetType item : items = AvailabilitySetType.values()) {
                if (!item.toString().equalsIgnoreCase(value)) continue;
                return item;
            }
            throw new IllegalArgumentException("Unexpected type: " + value);
        }

        public String toString() {
            return this.value;
        }
    }
}

