/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import com.google.auto.value.AutoValue;
import java.util.Date;
import org.jclouds.azurecompute.arm.domain.AutoValue_AlertModificationItem;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class AlertModificationItem {
    public abstract String comments();

    public abstract String description();

    public abstract AlertModificationEvent modificationEvent();

    public abstract Date modifiedAt();

    public abstract String modifiedBy();

    public abstract String newValue();

    public abstract String oldValue();

    @SerializedNames(value={"comments", "description", "modificationEvent", "modifiedAt", "modifiedBy", "newValue", "oldValue"})
    public static AlertModificationItem create(String comments, String description, AlertModificationEvent modificationEvent, Date modifiedAt, String modifiedBy, String newValue, String oldValue) {
        return AlertModificationItem.builder().comments(comments).description(description).modificationEvent(modificationEvent).modifiedAt(modifiedAt).modifiedBy(modifiedBy).newValue(newValue).oldValue(oldValue).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_AlertModificationItem.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder comments(String var1);

        public abstract Builder description(String var1);

        public abstract Builder modificationEvent(AlertModificationEvent var1);

        public abstract Builder modifiedAt(Date var1);

        public abstract Builder modifiedBy(String var1);

        public abstract Builder newValue(String var1);

        public abstract Builder oldValue(String var1);

        public abstract AlertModificationItem build();
    }

    public static enum AlertModificationEvent {
        AlertCreated,
        MonitorConditionChange,
        StateChange;


        public static AlertModificationEvent fromValue(String text) {
            return (AlertModificationEvent)GetEnumValue.fromValueOrDefault(text, AlertCreated);
        }
    }
}

