/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.options;

import com.google.common.base.Optional;
import org.jclouds.azurecompute.arm.compute.options.IpOptions;
import org.jclouds.javax.annotation.Nullable;

final class AutoValue_IpOptions
extends IpOptions {
    private final String subnet;
    private final Optional<String> address;
    private final boolean allocateNewPublicIp;
    private final String publicIpId;

    private AutoValue_IpOptions(String subnet, Optional<String> address, boolean allocateNewPublicIp, @Nullable String publicIpId) {
        this.subnet = subnet;
        this.address = address;
        this.allocateNewPublicIp = allocateNewPublicIp;
        this.publicIpId = publicIpId;
    }

    @Override
    public String subnet() {
        return this.subnet;
    }

    @Override
    public Optional<String> address() {
        return this.address;
    }

    @Override
    public boolean allocateNewPublicIp() {
        return this.allocateNewPublicIp;
    }

    @Override
    @Nullable
    public String publicIpId() {
        return this.publicIpId;
    }

    public String toString() {
        return "IpOptions{subnet=" + this.subnet + ", address=" + String.valueOf(this.address) + ", allocateNewPublicIp=" + this.allocateNewPublicIp + ", publicIpId=" + this.publicIpId + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IpOptions) {
            IpOptions that = (IpOptions)o;
            return this.subnet.equals(that.subnet()) && this.address.equals(that.address()) && this.allocateNewPublicIp == that.allocateNewPublicIp() && (this.publicIpId == null ? that.publicIpId() == null : this.publicIpId.equals(that.publicIpId()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subnet.hashCode();
        h$ *= 1000003;
        h$ ^= this.address.hashCode();
        h$ *= 1000003;
        h$ ^= this.allocateNewPublicIp ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.publicIpId == null ? 0 : this.publicIpId.hashCode();
    }

    @Override
    public IpOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends IpOptions.Builder {
        private String subnet;
        private Optional<String> address = Optional.absent();
        private Boolean allocateNewPublicIp;
        private String publicIpId;

        Builder() {
        }

        private Builder(IpOptions source) {
            this.subnet = source.subnet();
            this.address = source.address();
            this.allocateNewPublicIp = source.allocateNewPublicIp();
            this.publicIpId = source.publicIpId();
        }

        @Override
        public IpOptions.Builder subnet(String subnet) {
            if (subnet == null) {
                throw new NullPointerException("Null subnet");
            }
            this.subnet = subnet;
            return this;
        }

        @Override
        IpOptions.Builder address(Optional<String> address) {
            if (address == null) {
                throw new NullPointerException("Null address");
            }
            this.address = address;
            return this;
        }

        @Override
        public IpOptions.Builder allocateNewPublicIp(boolean allocateNewPublicIp) {
            this.allocateNewPublicIp = allocateNewPublicIp;
            return this;
        }

        @Override
        public IpOptions.Builder publicIpId(@Nullable String publicIpId) {
            this.publicIpId = publicIpId;
            return this;
        }

        @Override
        public IpOptions build() {
            Object missing = "";
            if (this.subnet == null) {
                missing = (String)missing + " subnet";
            }
            if (this.allocateNewPublicIp == null) {
                missing = (String)missing + " allocateNewPublicIp";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_IpOptions(this.subnet, this.address, this.allocateNewPublicIp, this.publicIpId);
        }
    }
}

