/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.functions;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.functions.AutoValue_VirtualMachineToStatus_StatusAndBackendStatus;
import org.jclouds.azurecompute.arm.domain.IdReference;
import org.jclouds.azurecompute.arm.domain.Status;
import org.jclouds.azurecompute.arm.domain.VirtualMachine;
import org.jclouds.azurecompute.arm.domain.VirtualMachineInstance;
import org.jclouds.azurecompute.arm.domain.VirtualMachineProperties;
import org.jclouds.compute.domain.NodeMetadata;

@Singleton
public class VirtualMachineToStatus
implements Function<VirtualMachine, StatusAndBackendStatus> {
    private static final Function<VirtualMachineProperties.ProvisioningState, NodeMetadata.Status> PROVISIONINGSTATE_TO_NODESTATUS = Functions.forMap((Map)ImmutableMap.builder().put((Object)VirtualMachineProperties.ProvisioningState.ACCEPTED, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachineProperties.ProvisioningState.READY, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachineProperties.ProvisioningState.CREATING, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachineProperties.ProvisioningState.RUNNING, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachineProperties.ProvisioningState.UPDATING, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachineProperties.ProvisioningState.DELETED, (Object)NodeMetadata.Status.TERMINATED).put((Object)VirtualMachineProperties.ProvisioningState.CANCELED, (Object)NodeMetadata.Status.TERMINATED).put((Object)VirtualMachineProperties.ProvisioningState.FAILED, (Object)NodeMetadata.Status.ERROR).put((Object)VirtualMachineProperties.ProvisioningState.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build(), (Object)NodeMetadata.Status.UNRECOGNIZED);
    private static final Function<VirtualMachineInstance.PowerState, NodeMetadata.Status> POWERSTATE_TO_NODESTATUS = Functions.forMap((Map)ImmutableMap.builder().put((Object)VirtualMachineInstance.PowerState.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)VirtualMachineInstance.PowerState.STARTING, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachineInstance.PowerState.STOPPED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)VirtualMachineInstance.PowerState.STOPPING, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachineInstance.PowerState.DEALLOCATED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)VirtualMachineInstance.PowerState.DEALLOCATING, (Object)NodeMetadata.Status.PENDING).put((Object)VirtualMachineInstance.PowerState.UNKNOWN, (Object)NodeMetadata.Status.UNRECOGNIZED).build(), (Object)NodeMetadata.Status.UNRECOGNIZED);
    private final AzureComputeApi api;

    @Inject
    VirtualMachineToStatus(AzureComputeApi api) {
        this.api = api;
    }

    public StatusAndBackendStatus apply(VirtualMachine virtualMachine) {
        String resourceGroup = IdReference.extractResourceGroup(virtualMachine.id());
        VirtualMachineProperties.ProvisioningState provisioningState = virtualMachine.properties().provisioningState();
        NodeMetadata.Status status = (NodeMetadata.Status)PROVISIONINGSTATE_TO_NODESTATUS.apply((Object)provisioningState);
        String backendStatus = provisioningState.name();
        if (VirtualMachineProperties.ProvisioningState.SUCCEEDED.equals((Object)provisioningState)) {
            VirtualMachineInstance instanceDetails = this.api.getVirtualMachineApi(resourceGroup).getInstanceDetails(virtualMachine.name());
            if (instanceDetails != null && instanceDetails.powerState() != null) {
                status = (NodeMetadata.Status)POWERSTATE_TO_NODESTATUS.apply((Object)instanceDetails.powerState());
                backendStatus = Joiner.on((char)',').join(Iterables.transform(instanceDetails.statuses(), (Function)new Function<Status, String>(){

                    public String apply(Status input) {
                        return input.code();
                    }
                }));
            } else {
                status = NodeMetadata.Status.PENDING;
            }
        }
        return StatusAndBackendStatus.create(status, backendStatus);
    }

    @AutoValue
    public static abstract class StatusAndBackendStatus {
        public abstract NodeMetadata.Status status();

        public abstract String backendStatus();

        public static StatusAndBackendStatus create(NodeMetadata.Status status, String backendStatus) {
            return new AutoValue_VirtualMachineToStatus_StatusAndBackendStatus(status, backendStatus);
        }
    }
}

