/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.jclouds.azurecompute.arm.compute.options.AzureTemplateOptions;
import org.jclouds.azurecompute.arm.domain.Plan;
import org.jclouds.azurecompute.arm.domain.VMImage;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.domain.Location;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.predicates.LocationPredicates;

public class VMImageToImage
implements Function<VMImage, Image> {
    private static final Map<String, OsFamily> OTHER_OS_MAP = ImmutableMap.builder().put((Object)"openlogic", (Object)OsFamily.CENTOS).put((Object)"win", (Object)OsFamily.WINDOWS).put((Object)"sles", (Object)OsFamily.SUSE).put((Object)"oracle-linux", (Object)OsFamily.OEL).build();
    private final Supplier<Set<? extends Location>> locations;

    @Inject
    VMImageToImage(@Memoized Supplier<Set<? extends Location>> locations) {
        this.locations = locations;
    }

    public Image apply(VMImage image) {
        ImageBuilder builder = new ImageBuilder();
        VMImageToImage.addMarketplacePlanToMetadataIfPresent(builder, image);
        Location location = (Location)FluentIterable.from((Iterable)((Iterable)this.locations.get())).firstMatch(LocationPredicates.idEquals((String)image.location())).get();
        if (image.custom()) {
            builder.id(image.encodeFieldsToUniqueIdCustom()).providerId(image.customImageId()).name(image.name()).location(location).description(image.group()).status(Image.Status.AVAILABLE).version("latest");
        } else {
            builder.id(image.encodeFieldsToUniqueId()).providerId(image.publisher()).name(image.offer()).location(location).description(image.sku()).status(Image.Status.AVAILABLE).version(image.sku());
        }
        OperatingSystem.Builder osBuilder = (OperatingSystem.Builder)VMImageToImage.osFamily().apply((Object)image);
        builder.operatingSystem(osBuilder.build());
        return builder.build();
    }

    private static void addMarketplacePlanToMetadataIfPresent(ImageBuilder builder, VMImage image) {
        if (image.versionProperties() != null && image.versionProperties().plan() != null) {
            Plan plan = image.versionProperties().plan();
            builder.userMetadata((Map)ImmutableMap.of((Object)"publisher", (Object)plan.publisher(), (Object)"name", (Object)plan.name(), (Object)"product", (Object)plan.product()));
        }
    }

    @Nullable
    public static Plan createMarketplacePlanIfPresent(Image image, AzureTemplateOptions templateOptions) {
        Map imageMetadata = image.getUserMetadata();
        String planPublisher = VMImageToImage.getFirstNonEmptyOrReturnNull(templateOptions.getPlanPublisher(), (String)imageMetadata.get("publisher"));
        String planName = VMImageToImage.getFirstNonEmptyOrReturnNull(templateOptions.getPlanName(), (String)imageMetadata.get("name"));
        String planProduct = VMImageToImage.getFirstNonEmptyOrReturnNull(templateOptions.getPlanProduct(), (String)imageMetadata.get("product"));
        if (Strings.isNullOrEmpty((String)planPublisher) || Strings.isNullOrEmpty((String)planName) || Strings.isNullOrEmpty((String)planProduct)) {
            return null;
        }
        return Plan.create(planPublisher, planName, planProduct);
    }

    @Nullable
    private static String getFirstNonEmptyOrReturnNull(String first, String second) {
        if (!Strings.isNullOrEmpty((String)first)) {
            return first;
        }
        if (!Strings.isNullOrEmpty((String)second)) {
            return second;
        }
        return null;
    }

    public static Function<VMImage, OperatingSystem.Builder> osFamily() {
        return new Function<VMImage, OperatingSystem.Builder>(){

            public OperatingSystem.Builder apply(VMImage image) {
                String label = ((String)Preconditions.checkNotNull((Object)image.offer(), (Object)"offer")).toLowerCase();
                OsFamily family = (OsFamily)VMImageToImage.findInStandardFamilies(label).or(VMImageToImage.findInOtherOSMap(label)).or((Object)OsFamily.UNRECOGNIZED);
                if (OsFamily.UNRECOGNIZED == family && image.versionProperties() != null && image.versionProperties().osDiskImage() != null && image.versionProperties().osDiskImage().operatingSystem() != null) {
                    family = OsFamily.fromValue((String)image.versionProperties().osDiskImage().operatingSystem().toUpperCase());
                }
                return OperatingSystem.builder().family(family).is64Bit(true).description(image.custom() ? "custom" : image.sku()).version(image.custom() ? "latest" : image.sku());
            }
        };
    }

    private static Optional<OsFamily> findInStandardFamilies(final String label) {
        return Iterables.tryFind(Arrays.asList(OsFamily.values()), (Predicate)new Predicate<OsFamily>(){

            public boolean apply(OsFamily input) {
                return label.contains(input.value());
            }
        });
    }

    private static Optional<OsFamily> findInOtherOSMap(final String label) {
        return Iterables.tryFind(OTHER_OS_MAP.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return label.contains(input);
            }
        }).transform((Function)new Function<String, OsFamily>(){

            public OsFamily apply(String input) {
                return OTHER_OS_MAP.get(input);
            }
        });
    }
}

