/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.HashMap;
import org.jclouds.azurecompute.arm.AzureComputeApi;
import org.jclouds.azurecompute.arm.compute.options.AzureTemplateOptions;
import org.jclouds.azurecompute.arm.domain.AvailabilitySet;
import org.jclouds.compute.domain.Template;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;

@Singleton
public class TemplateToAvailabilitySet
implements Function<Template, AvailabilitySet> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final AzureComputeApi api;

    @Inject
    TemplateToAvailabilitySet(AzureComputeApi api) {
        this.api = api;
    }

    @Nullable
    public AvailabilitySet apply(Template input) {
        Preconditions.checkArgument((boolean)(input.getOptions() instanceof AzureTemplateOptions), (Object)"An AzureTemplateOptions object is required");
        AzureTemplateOptions options = (AzureTemplateOptions)input.getOptions().as(AzureTemplateOptions.class);
        AvailabilitySet availabilitySet = null;
        String location = input.getLocation().getId();
        String resourceGroup = options.getResourceGroup();
        if (options.getAvailabilitySetName() != null) {
            availabilitySet = this.api.getAvailabilitySetApi(resourceGroup).get(options.getAvailabilitySetName());
            Preconditions.checkArgument((availabilitySet != null ? 1 : 0) != 0, (String)"No availability set with name '%s' was found", (Object)options.getAvailabilitySetName());
            Preconditions.checkArgument((boolean)location.equals(availabilitySet.location()), (String)"The availability set %s does not belong to location %s", (Object)options.getAvailabilitySetName(), (Object)location);
        } else if (options.getAvailabilitySet() != null) {
            availabilitySet = this.api.getAvailabilitySetApi(resourceGroup).get(options.getAvailabilitySet().name());
            if (availabilitySet != null) {
                Preconditions.checkArgument((boolean)location.equals(availabilitySet.location()), (String)"The availability set %s does not belong to location %s", (Object)options.getAvailabilitySet().name(), (Object)location);
            } else {
                HashMap<String, String> tags = new HashMap<String, String>();
                if (options.getAvailabilitySet().tags() != null) {
                    tags.putAll(options.getAvailabilitySet().tags());
                }
                tags.put("jclouds", options.getAvailabilitySet().name());
                this.logger.debug(">> creating availability set [%s]", new Object[]{options.getAvailabilitySet().name()});
                availabilitySet = this.api.getAvailabilitySetApi(resourceGroup).createOrUpdate(options.getAvailabilitySet().name(), options.getAvailabilitySet().sku(), location, tags, options.getAvailabilitySet().properties());
            }
        }
        return availabilitySet;
    }
}

