/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import jakarta.annotation.Resource;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRule;
import org.jclouds.azurecompute.arm.domain.NetworkSecurityRuleProperties;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.net.util.IpPermissions;

@Singleton
public class NetworkSecurityRuleToIpPermission
implements Function<NetworkSecurityRule, IpPermission> {
    public static final Predicate<NetworkSecurityRule> InboundRule = new Predicate<NetworkSecurityRule>(){

        public boolean apply(NetworkSecurityRule input) {
            return NetworkSecurityRuleProperties.Direction.Inbound.equals((Object)input.properties().direction()) && NetworkSecurityRuleProperties.Access.Allow.equals((Object)input.properties().access());
        }
    };
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    public IpPermission apply(NetworkSecurityRule rule) {
        if (!InboundRule.apply((Object)rule)) {
            this.logger.warn(">> ignoring non-inbound network security rule %s...", new Object[]{rule.name()});
            return null;
        }
        IpPermissions.PortSelection permissions = IpPermissions.permit((IpProtocol)IpProtocol.fromValue((String)rule.properties().protocol().name()));
        String portRange = rule.properties().destinationPortRange();
        if (!"*".equals(portRange)) {
            String[] range = portRange.split("-");
            permissions = ((IpPermissions.PortSelection)IpPermissions.PortSelection.class.cast(permissions)).fromPort(Integer.parseInt(range[0])).to(Integer.parseInt(range[range.length - 1]));
        }
        if (!"*".equals(rule.properties().sourceAddressPrefix())) {
            permissions = ((IpPermissions.ToSourceSelection)IpPermissions.ToSourceSelection.class.cast(permissions)).originatingFromCidrBlock(rule.properties().sourceAddressPrefix());
        }
        return permissions;
    }
}

