/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.domain;

import com.google.auto.value.AutoValue;
import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import org.jclouds.azurecompute.arm.compute.domain.AutoValue_ResourceGroupAndNameAndIngressRules;
import org.jclouds.azurecompute.arm.compute.domain.ResourceGroupAndName;

@AutoValue
public abstract class ResourceGroupAndNameAndIngressRules {
    abstract ResourceGroupAndName resourceGroupAndName();

    public abstract String location();

    public abstract int[] inboundPorts();

    ResourceGroupAndNameAndIngressRules() {
    }

    public static ResourceGroupAndNameAndIngressRules create(String resourceGroup, String location, String name, int[] inboundPorts) {
        return new AutoValue_ResourceGroupAndNameAndIngressRules(ResourceGroupAndName.fromResourceGroupAndName(resourceGroup, name), location, Arrays.copyOf(inboundPorts, inboundPorts.length));
    }

    public String name() {
        return this.resourceGroupAndName().name();
    }

    public String resourceGroup() {
        return this.resourceGroupAndName().resourceGroup();
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.resourceGroup(), this.name()});
    }

    @SuppressFBWarnings(value={"EQ_UNUSUAL"})
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ResourceGroupAndName)) {
            return false;
        }
        ResourceGroupAndName that = (ResourceGroupAndName)obj;
        return Objects.equal((Object)this.resourceGroup(), (Object)that.resourceGroup()) && Objects.equal((Object)this.name(), (Object)that.name());
    }
}

