/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.compute.domain;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import org.jclouds.azurecompute.arm.compute.domain.AutoValue_LocationAndName;

@AutoValue
public abstract class LocationAndName {
    public abstract String location();

    public abstract String name();

    protected LocationAndName() {
    }

    public static LocationAndName fromSlashEncoded(String id) {
        Iterable parts = Splitter.on((char)'/').split((CharSequence)Preconditions.checkNotNull((Object)id, (Object)"id"));
        Preconditions.checkArgument((Iterables.size((Iterable)parts) == 2 ? 1 : 0) != 0, (Object)"id must be in format location/name");
        return new AutoValue_LocationAndName((String)Iterables.get((Iterable)parts, (int)0), (String)Iterables.get((Iterable)parts, (int)1));
    }

    public static LocationAndName fromLocationAndName(String location, String name) {
        return new AutoValue_LocationAndName(location, name);
    }

    public String slashEncode() {
        return this.location() + "/" + this.name();
    }
}

