/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.TypeLiteral;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.digitalocean2.domain.internal.PaginatedCollection;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.functions.BaseToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;

@Path(value="/regions")
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface RegionApi
extends Closeable {
    @Named(value="region:list")
    @GET
    @ResponseParser(value=ParseRegions.class)
    @Transform(value=ParseRegions.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Region> list();

    @Named(value="region:list")
    @GET
    @ResponseParser(value=ParseRegions.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Region> list(ListOptions var1);

    public static final class ParseRegions
    extends ParseJson<Regions> {
        @Inject
        ParseRegions(Json json) {
            super(json, TypeLiteral.get(Regions.class));
        }

        private static class Regions
        extends PaginatedCollection<Region> {
            @ConstructorProperties(value={"regions", "meta", "links"})
            public Regions(List<Region> items, PaginatedCollection.Meta meta, PaginatedCollection.Links links) {
                super(items, meta, links);
            }
        }

        static class ToPagedIterable
        extends BaseToPagedIterable<Region, ListOptions> {
            @Inject
            ToPagedIterable(DigitalOcean2Api api, Function<URI, ListOptions> linkToOptions) {
                super(api, linkToOptions);
            }

            @Override
            protected IterableWithMarker<Region> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.regionApi().list(options);
            }
        }
    }
}

