/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.domain;

import com.google.auto.value.AutoValue;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.digitalocean2.domain.AutoValue_Networks;
import org.jclouds.digitalocean2.domain.AutoValue_Networks_Address;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class Networks {
    public abstract List<Address> ipv4();

    public abstract List<Address> ipv6();

    @SerializedNames(value={"v4", "v6"})
    public static Networks create(List<Address> ipv4, List<Address> ipv6) {
        return new AutoValue_Networks((List<Address>)ImmutableList.copyOf(ipv4), (List<Address>)ImmutableList.copyOf(ipv6));
    }

    Networks() {
    }

    public static class Predicates {
        public static Predicate<Address> publicNetworks() {
            return new Predicate<Address>(){

                public boolean apply(Address network) {
                    return network.type().equals("public");
                }
            };
        }

        public static Predicate<Address> privateNetworks() {
            return new Predicate<Address>(){

                public boolean apply(Address network) {
                    return network.type().equals("private");
                }
            };
        }
    }

    @AutoValue
    public static abstract class Address {
        public abstract String ip();

        public abstract String netmask();

        public abstract String gateway();

        public abstract String type();

        @SerializedNames(value={"ip_address", "netmask", "gateway", "type"})
        public static Address create(String ip, String netmask, String gateway, String type) {
            return new AutoValue_Networks_Address(ip, netmask, gateway, type);
        }

        Address() {
        }
    }
}

