/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.domain;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.digitalocean2.domain.AutoValue_Action;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class Action {
    public abstract long id();

    public abstract Status status();

    public abstract String type();

    public abstract Date startedAt();

    @Nullable
    public abstract Date completedAt();

    public abstract long resourceId();

    public abstract String resourceType();

    @Nullable
    public abstract Region region();

    @Nullable
    public abstract String regionSlug();

    @SerializedNames(value={"id", "status", "type", "started_at", "completed_at", "resource_id", "resource_type", "region", "region_slug"})
    public static Action create(long id, Status status, String type, Date startedAt, Date completedAt, long resourceId, String resourceType, Region region, String regionSlug) {
        return new AutoValue_Action(id, status, type, startedAt, completedAt, resourceId, resourceType, region, regionSlug);
    }

    Action() {
    }

    public static enum Status {
        COMPLETED,
        IN_PROGRESS,
        ERRORED;


        public static Status fromValue(String value) {
            Optional status = Enums.getIfPresent(Status.class, (String)value.toUpperCase());
            if (!status.isPresent()) {
                String upperCamelValue = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, value.toLowerCase());
                status = Enums.getIfPresent(Status.class, (String)upperCamelValue);
            }
            Preconditions.checkArgument((boolean)status.isPresent(), (String)"Expected one of %s but was", (Object)Joiner.on((char)',').join((Object[])Status.values()), (Object)value);
            return (Status)((Object)status.get());
        }
    }
}

