/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.internal;

import com.google.auto.value.AutoValue;
import org.jclouds.digitalocean2.compute.internal.AutoValue_ImageInRegion;
import org.jclouds.digitalocean2.domain.Image;

@AutoValue
public abstract class ImageInRegion {
    public abstract Image image();

    public abstract String region();

    public static ImageInRegion create(Image image, String region) {
        return new AutoValue_ImageInRegion(image, region);
    }

    public static String encodeId(ImageInRegion imageInRegion) {
        return String.format("%s/%s", imageInRegion.region(), ImageInRegion.slugOrId(imageInRegion.image()));
    }

    public static String extractRegion(String imageId) {
        return imageId.substring(0, imageId.indexOf(47));
    }

    public static String extractImageId(String imageId) {
        return imageId.substring(imageId.indexOf(47) + 1);
    }

    private static String slugOrId(Image image) {
        return image.slug() != null ? image.slug() : String.valueOf(image.id());
    }

    ImageInRegion() {
    }
}

