/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import jakarta.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatement;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatementWithoutPublicKey;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.compute.DigitalOcean2ComputeServiceAdapter;
import org.jclouds.digitalocean2.compute.extensions.DigitalOcean2ImageExtension;
import org.jclouds.digitalocean2.compute.functions.DropletStatusToStatus;
import org.jclouds.digitalocean2.compute.functions.DropletToNodeMetadata;
import org.jclouds.digitalocean2.compute.functions.ImageInRegionToImage;
import org.jclouds.digitalocean2.compute.functions.RegionToLocation;
import org.jclouds.digitalocean2.compute.functions.SizeToHardware;
import org.jclouds.digitalocean2.compute.internal.ImageInRegion;
import org.jclouds.digitalocean2.compute.options.DigitalOcean2TemplateOptions;
import org.jclouds.digitalocean2.compute.strategy.CreateKeyPairsThenCreateNodes;
import org.jclouds.digitalocean2.domain.Action;
import org.jclouds.digitalocean2.domain.Droplet;
import org.jclouds.digitalocean2.domain.Region;
import org.jclouds.digitalocean2.domain.Size;
import org.jclouds.domain.Location;
import org.jclouds.util.Predicates2;

public class DigitalOcean2ComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Droplet, Size, ImageInRegion, Region> {
    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<Droplet, Size, ImageInRegion, Region>>(){}).to(DigitalOcean2ComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Droplet, NodeMetadata>>(){}).to(DropletToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ImageInRegion, Image>>(){}).to(ImageInRegionToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Region, Location>>(){}).to(RegionToLocation.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Size, Hardware>>(){}).to(SizeToHardware.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Droplet.Status, NodeMetadata.Status>>(){}).to(DropletStatusToStatus.class);
        this.install((Module)new ComputeServiceAdapterContextModule.LocationsFromComputeServiceAdapterModule<Droplet, Size, ImageInRegion, Region>(){});
        this.bind(CreateNodesInGroupThenAddToSet.class).to(CreateKeyPairsThenCreateNodes.class);
        this.bind(TemplateOptions.class).to(DigitalOcean2TemplateOptions.class);
        this.bind(NodeAndTemplateOptionsToStatement.class).to(NodeAndTemplateOptionsToStatementWithoutPublicKey.class);
        this.bind((TypeLiteral)new TypeLiteral<ImageExtension>(){}).to(DigitalOcean2ImageExtension.class);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-running")
    protected Predicate<Integer> provideDropletRunningPredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new DropletInStatusPredicate(api, Droplet.Status.ACTIVE), (long)timeouts.nodeRunning, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-suspended")
    protected Predicate<Integer> provideDropletSuspendedPredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new DropletInStatusPredicate(api, Droplet.Status.OFF), (long)timeouts.nodeSuspended, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-terminated")
    protected Predicate<Integer> provideDropletTerminatedPredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new DropletTerminatedPredicate(api), (long)timeouts.nodeTerminated, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.image-available")
    protected Predicate<Long> provideImageAvailablePredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ActionDonePredicate(api), (long)timeouts.imageAvailable, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    @Singleton
    protected Predicate<Region> provideRegionAvailablePredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new RegionAvailablePredicate(), (long)timeouts.imageAvailable, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @Provides
    protected Predicate<Long> provideActionCompletedPredicate(DigitalOcean2Api api, ComputeServiceConstants.Timeouts timeouts, ComputeServiceConstants.PollPeriod pollPeriod) {
        return Predicates2.retry((Predicate)new ActionDonePredicate(api), (long)timeouts.imageAvailable, (long)pollPeriod.pollInitialPeriod, (long)pollPeriod.pollMaxPeriod);
    }

    @VisibleForTesting
    static class DropletInStatusPredicate
    implements Predicate<Integer> {
        private final DigitalOcean2Api api;
        private final Droplet.Status status;

        public DropletInStatusPredicate(DigitalOcean2Api api, Droplet.Status status) {
            this.api = (DigitalOcean2Api)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
            this.status = (Droplet.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status must not be null"));
        }

        public boolean apply(Integer input) {
            Preconditions.checkNotNull((Object)input, (Object)"droplet id");
            Droplet droplet = this.api.dropletApi().get(input);
            return droplet != null && this.status == droplet.status();
        }
    }

    @VisibleForTesting
    static class DropletTerminatedPredicate
    implements Predicate<Integer> {
        private final DigitalOcean2Api api;

        public DropletTerminatedPredicate(DigitalOcean2Api api) {
            this.api = (DigitalOcean2Api)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
        }

        public boolean apply(Integer input) {
            Preconditions.checkNotNull((Object)input, (Object)"droplet id");
            Droplet droplet = this.api.dropletApi().get(input);
            return droplet == null;
        }
    }

    @VisibleForTesting
    static class ActionDonePredicate
    implements Predicate<Long> {
        private final DigitalOcean2Api api;

        public ActionDonePredicate(DigitalOcean2Api api) {
            this.api = (DigitalOcean2Api)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
        }

        public boolean apply(Long input) {
            Preconditions.checkNotNull((Object)input, (Object)"action id cannot be null");
            Action current = this.api.actionApi().get(input);
            switch (current.status()) {
                case COMPLETED: {
                    return true;
                }
                case IN_PROGRESS: {
                    return false;
                }
            }
            throw new IllegalStateException("Resource is in invalid status: " + current.status().name());
        }
    }

    @VisibleForTesting
    static class RegionAvailablePredicate
    implements Predicate<Region> {
        RegionAvailablePredicate() {
        }

        public boolean apply(Region input) {
            return input.available();
        }
    }
}

