/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloudstorage.domain.ObjectAccessControls;
import org.jclouds.googlecloudstorage.domain.templates.ObjectAccessControlsTemplate;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface ObjectAccessControlsApi {
    @Named(value="ObjectAccessControls:get")
    @GET
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public ObjectAccessControls getObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3);

    @Named(value="ObjectAccessControls:get")
    @GET
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public ObjectAccessControls getObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @QueryParam(value="generation") Long var4);

    @Named(value="ObjectAccessControls:insert")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl")
    public ObjectAccessControls createObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var3);

    @Named(value="ObjectAccessControls:insert")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl")
    public ObjectAccessControls createObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var3, @QueryParam(value="generation") Long var4);

    @Named(value="ObjectAccessControls:delete")
    @DELETE
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public void deleteObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3);

    @Named(value="ObjectAccessControls:delete")
    @DELETE
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public void deleteObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @QueryParam(value="generation") Long var4);

    @Named(value="ObjectAccessControls:list")
    @GET
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl")
    @SelectJson(value={"items"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public List<ObjectAccessControls> listObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2);

    @Named(value="ObjectAccessControls:list")
    @GET
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl")
    @SelectJson(value={"items"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public List<ObjectAccessControls> listObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @QueryParam(value="generation") Long var3);

    @Named(value="ObjectAccessControls:update")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public ObjectAccessControls updateObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var4);

    @Named(value="ObjectAccessControls:update")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public ObjectAccessControls updateObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var4, @QueryParam(value="generation") Long var5);

    @Named(value="ObjectAccessControls:patch")
    @POST
    @Headers(keys={"X-HTTP-Method-Override"}, values={"PATCH"})
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public ObjectAccessControls patchObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var4);

    @Named(value="ObjectAccessControls:patch")
    @POST
    @Headers(keys={"X-HTTP-Method-Override"}, values={"PATCH"})
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/o/{object}/acl/{entity}")
    public ObjectAccessControls patchObjectAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="object") @Encoded String var2, @PathParam(value="entity") String var3, @BinderParam(value=BindToJsonPayload.class) ObjectAccessControlsTemplate var4, @QueryParam(value="generation") Long var5);
}

