/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloudstorage.domain.BucketAccessControls;
import org.jclouds.googlecloudstorage.domain.templates.BucketAccessControlsTemplate;
import org.jclouds.http.HttpResponse;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface BucketAccessControlsApi {
    @Named(value="BucketAccessControls:get")
    @GET
    @Path(value="/b/{bucket}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public BucketAccessControls getBucketAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="entity") String var2);

    @Named(value="BucketAccessControls:insert")
    @POST
    @Path(value="/b/{bucket}/acl")
    public BucketAccessControls createBucketAccessControls(@PathParam(value="bucket") String var1, @BinderParam(value=BindToJsonPayload.class) BucketAccessControlsTemplate var2);

    @Named(value="BucketAccessControls:delete")
    @DELETE
    @Path(value="/b/{bucket}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public HttpResponse deleteBucketAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="entity") String var2);

    @Named(value="BucketAccessControls:list")
    @GET
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/acl")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    @SelectJson(value={"items"})
    public List<BucketAccessControls> listBucketAccessControls(@PathParam(value="bucket") String var1);

    @Named(value="BucketAccessControls:update")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public BucketAccessControls updateBucketAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="entity") String var2, @BinderParam(value=BindToJsonPayload.class) BucketAccessControlsTemplate var3);

    @Named(value="BucketAccessControls:patch")
    @POST
    @Headers(keys={"X-HTTP-Method-Override"}, values={"PATCH"})
    @Produces(value={"application/json"})
    @Path(value="/b/{bucket}/acl/{entity}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public BucketAccessControls patchBucketAccessControls(@PathParam(value="bucket") String var1, @PathParam(value="entity") String var2, @BinderParam(value=BindToJsonPayload.class) BucketAccessControlsTemplate var3);
}

