/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.domain;

import com.google.auto.value.AutoValue;
import org.jclouds.googlecloudstorage.domain.AutoValue_ObjectAccessControls;
import org.jclouds.googlecloudstorage.domain.DomainResourceReferences;
import org.jclouds.googlecloudstorage.domain.ProjectTeam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class ObjectAccessControls {
    private final String kind = "storage#objectAccessControl";

    @Nullable
    public abstract String id();

    @Nullable
    public abstract String bucket();

    @Nullable
    public abstract String object();

    @Nullable
    public abstract Long generation();

    public abstract String entity();

    @Nullable
    public abstract String entityId();

    public abstract DomainResourceReferences.ObjectRole role();

    @Nullable
    public abstract String email();

    @Nullable
    public abstract String domain();

    @Nullable
    public abstract ProjectTeam projectTeam();

    @SerializedNames(value={"id", "bucket", "object", "generation", "entity", "entityId", "role", "email", "domain", "projectTeam"})
    public static ObjectAccessControls create(String id, String bucket, String object, Long generation, String entity, String entityId, DomainResourceReferences.ObjectRole role, String email, String domain, ProjectTeam projectTeam) {
        return new AutoValue_ObjectAccessControls(id, bucket, object, generation, entity, entityId, role, email, domain, projectTeam);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String object;
        private Long generation;
        private String bucket;
        private String entity;
        private String entityId;
        private DomainResourceReferences.ObjectRole role;
        private String email;
        private String domain;
        private ProjectTeam projectTeam;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder object(String object) {
            this.object = object;
            return this;
        }

        public Builder generation(Long generation) {
            this.generation = generation;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder role(DomainResourceReferences.ObjectRole role) {
            this.role = role;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder projectTeam(ProjectTeam projectTeam) {
            this.projectTeam = projectTeam;
            return this;
        }

        public ObjectAccessControls build() {
            return ObjectAccessControls.create(this.id, this.bucket, this.object, this.generation, this.entity, this.entityId, this.role, this.email, this.domain, this.projectTeam);
        }
    }
}

