/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.domain;

import com.google.auto.value.AutoValue;
import org.jclouds.googlecloudstorage.domain.AutoValue_BucketAccessControls;
import org.jclouds.googlecloudstorage.domain.ProjectTeam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class BucketAccessControls {
    public abstract String kind();

    public abstract String id();

    public abstract String bucket();

    public abstract String entity();

    @Nullable
    public abstract String entityId();

    public abstract Role role();

    @Nullable
    public abstract String email();

    @Nullable
    public abstract String domain();

    @Nullable
    public abstract ProjectTeam projectTeam();

    @SerializedNames(value={"kind", "id", "bucket", "entity", "entityId", "role", "email", "domain", "projectTeam"})
    static BucketAccessControls create(String kind, String id, String bucket, String entity, String entityId, Role role, String email, String domain, ProjectTeam projectTeam) {
        return new AutoValue_BucketAccessControls(kind, (String)(id == null ? bucket + "/" + entity : id), bucket, entity, entityId, role, email, domain, projectTeam);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum Role {
        READER,
        WRITER,
        OWNER;

    }

    public static final class Builder {
        private String id;
        private String bucket;
        private String entity;
        private String entityId;
        private Role role;
        private String email;
        private String domain;
        private ProjectTeam projectTeam;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder role(Role role) {
            this.role = role;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder projectTeam(ProjectTeam projectTeam) {
            this.projectTeam = projectTeam;
            return this;
        }

        public BucketAccessControls build() {
            return BucketAccessControls.create("storage#bucketAccessControl", this.id, this.bucket, this.entity, this.entityId, this.role, this.email, this.domain, this.projectTeam);
        }
    }
}

