/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.config;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.googlecloudstorage.config.AutoValue_GoogleCloudStorageOAuthScopes;
import org.jclouds.http.HttpRequest;
import org.jclouds.oauth.v2.config.OAuthScopes;

@AutoValue
public abstract class GoogleCloudStorageOAuthScopes
implements OAuthScopes {
    abstract OAuthScopes readOrWriteScopes();

    abstract List<String> fullControlScopes();

    public static GoogleCloudStorageOAuthScopes create() {
        return new AutoValue_GoogleCloudStorageOAuthScopes((OAuthScopes)OAuthScopes.ReadOrWriteScopes.create((String)"https://www.googleapis.com/auth/devstorage.read_only", (String)"https://www.googleapis.com/auth/devstorage.read_write"), (List<String>)ImmutableList.of((Object)"https://www.googleapis.com/auth/devstorage.full_control"));
    }

    public List<String> forRequest(HttpRequest input) {
        String path = input.getEndpoint().getPath();
        if (path.endsWith("/acl") || path.endsWith("/defaultObjectAcl") || path.contains("/acl/") || path.contains("/defaultObjectAcl/")) {
            return this.fullControlScopes();
        }
        if (input.getMethod().equalsIgnoreCase("PUT") || input.getMethod().equalsIgnoreCase("PATCH")) {
            return this.fullControlScopes();
        }
        if ("PATCH".equalsIgnoreCase(input.getFirstHeaderOrNull("X-HTTP-Method-Override"))) {
            return this.fullControlScopes();
        }
        return this.readOrWriteScopes().forRequest(input);
    }

    GoogleCloudStorageOAuthScopes() {
    }
}

