/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Provides;
import jakarta.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.googlecloud.config.CurrentProject;
import org.jclouds.googlecloudstorage.GoogleCloudStorageApi;
import org.jclouds.googlecloudstorage.config.GoogleCloudStorageOAuthScopes;
import org.jclouds.googlecloudstorage.handlers.GoogleCloudStorageClientErrorRetryHandler;
import org.jclouds.googlecloudstorage.handlers.GoogleCloudStorageErrorHandler;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.location.Provider;
import org.jclouds.oauth.v2.config.OAuthScopes;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class GoogleCloudStorageHttpApiModule
extends HttpApiModule<GoogleCloudStorageApi> {
    public void configure() {
        super.configure();
        this.bind(OAuthScopes.class).toInstance((Object)GoogleCloudStorageOAuthScopes.create());
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(GoogleCloudStorageErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(GoogleCloudStorageErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(GoogleCloudStorageErrorHandler.class);
    }

    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(GoogleCloudStorageClientErrorRetryHandler.class);
    }

    @Provides
    @Singleton
    @CurrentProject
    public Supplier<String> supplyProject(@Provider Supplier<Credentials> creds) {
        return Suppliers.compose((Function)new Function<Credentials, String>(){

            public String apply(Credentials in) {
                return CurrentProject.ClientEmail.toProjectNumber((String)in.identity);
            }
        }, creds);
    }
}

