/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import com.google.auto.value.AutoValue;
import com.google.common.base.Enums;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.profitbricks.domain.AutoValue_Storage;
import org.jclouds.profitbricks.domain.AutoValue_Storage_Request_ConnectPayload;
import org.jclouds.profitbricks.domain.AutoValue_Storage_Request_CreatePayload;
import org.jclouds.profitbricks.domain.AutoValue_Storage_Request_UpdatePayload;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.util.Preconditions;

@AutoValue
public abstract class Storage {
    public abstract String id();

    @Nullable
    public abstract String name();

    public abstract float size();

    @Nullable
    public abstract Date creationTime();

    @Nullable
    public abstract Date lastModificationTime();

    @Nullable
    public abstract ProvisioningState state();

    @Nullable
    public abstract List<String> serverIds();

    @Nullable
    public abstract Boolean bootDevice();

    @Nullable
    public abstract BusType busType();

    @Nullable
    public abstract Integer deviceNumber();

    public static Builder builder() {
        return new AutoValue_Storage.Builder().serverIds((List<String>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder size(float var1);

        public abstract Builder creationTime(Date var1);

        public abstract Builder lastModificationTime(Date var1);

        public abstract Builder state(ProvisioningState var1);

        public abstract Builder serverIds(List<String> var1);

        public abstract Builder bootDevice(Boolean var1);

        public abstract Builder busType(BusType var1);

        public abstract Builder deviceNumber(Integer var1);

        abstract Storage autoBuild();

        public Storage build() {
            Storage built = this.autoBuild();
            return built.toBuilder().serverIds((List<String>)ImmutableList.copyOf(built.serverIds())).autoBuild();
        }
    }

    public static final class Request {
        public static CreatePayload.Builder creatingBuilder() {
            return new AutoValue_Storage_Request_CreatePayload.Builder();
        }

        public static UpdatePayload.Builder updatingBuilder() {
            return new AutoValue_Storage_Request_UpdatePayload.Builder();
        }

        public static ConnectPayload.Builder connectingBuilder() {
            return new AutoValue_Storage_Request_ConnectPayload.Builder();
        }

        @AutoValue
        public static abstract class ConnectPayload {
            public abstract String storageId();

            public abstract String serverId();

            @Nullable
            public abstract BusType busType();

            @Nullable
            public abstract Integer deviceNumber();

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder storageId(String var1);

                public abstract Builder serverId(String var1);

                public abstract Builder busType(BusType var1);

                public abstract Builder deviceNumber(Integer var1);

                public abstract ConnectPayload build();
            }
        }

        @AutoValue
        public static abstract class UpdatePayload {
            public abstract String id();

            @Nullable
            public abstract Float size();

            @Nullable
            public abstract String name();

            @Nullable
            public abstract String mountImageId();

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder id(String var1);

                public abstract Builder size(Float var1);

                public abstract Builder name(String var1);

                public abstract Builder mountImageId(String var1);

                abstract UpdatePayload autoBuild();

                public UpdatePayload build() {
                    UpdatePayload payload = this.autoBuild();
                    if (payload.size() != null) {
                        Preconditions.checkSize(payload.size());
                    }
                    return payload;
                }
            }
        }

        @AutoValue
        public static abstract class CreatePayload {
            public abstract String dataCenterId();

            public abstract float size();

            @Nullable
            public abstract String name();

            @Nullable
            public abstract String mountImageId();

            @Nullable
            public abstract String imagePassword();

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder dataCenterId(String var1);

                public abstract Builder size(float var1);

                public abstract Builder name(String var1);

                public abstract Builder mountImageId(String var1);

                public abstract Builder imagePassword(String var1);

                abstract CreatePayload autoBuild();

                public CreatePayload build() {
                    CreatePayload payload = this.autoBuild();
                    if (payload.imagePassword() != null) {
                        Preconditions.checkPassword(payload.imagePassword());
                    }
                    Preconditions.checkSize(Float.valueOf(payload.size()));
                    return payload;
                }
            }
        }
    }

    public static enum BusType {
        IDE,
        SCSI,
        VIRTIO,
        UNRECOGNIZED;


        public static BusType fromValue(String value) {
            return (BusType)((Object)Enums.getIfPresent(BusType.class, (String)value).or((Object)UNRECOGNIZED));
        }
    }
}

