/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import com.google.auto.value.AutoValue;
import java.util.Date;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.profitbricks.domain.AutoValue_Snapshot;
import org.jclouds.profitbricks.domain.AutoValue_Snapshot_Request_CreatePayload;
import org.jclouds.profitbricks.domain.AutoValue_Snapshot_Request_RollbackPayload;
import org.jclouds.profitbricks.domain.AutoValue_Snapshot_Request_UpdatePayload;
import org.jclouds.profitbricks.domain.Location;
import org.jclouds.profitbricks.domain.OsType;
import org.jclouds.profitbricks.domain.Provisionable;
import org.jclouds.profitbricks.domain.ProvisioningState;

@AutoValue
public abstract class Snapshot
implements Provisionable {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract Float size();

    @Nullable
    public abstract Location location();

    @Nullable
    public abstract OsType osType();

    @Nullable
    public abstract Boolean isBootable();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract Date creationTime();

    @Nullable
    public abstract Date lastModificationTime();

    @Nullable
    public abstract ProvisioningState state();

    @Nullable
    public abstract Boolean isCpuHotPlug();

    @Nullable
    public abstract Boolean isCpuHotUnPlug();

    @Nullable
    public abstract Boolean isRamHotPlug();

    @Nullable
    public abstract Boolean isRamHotUnPlug();

    @Nullable
    public abstract Boolean isNicHotPlug();

    @Nullable
    public abstract Boolean isNicHotUnPlug();

    @Nullable
    public abstract Boolean isDiscVirtioHotPlug();

    @Nullable
    public abstract Boolean isDiscVirtioHotUnPlug();

    public static Builder builder() {
        return new AutoValue_Snapshot.Builder();
    }

    public abstract Builder toBuilder();

    public static final class Request {
        public static CreatePayload.Builder creatingBuilder() {
            return new AutoValue_Snapshot_Request_CreatePayload.Builder();
        }

        public static UpdatePayload.Builder updatingBuilder() {
            return new AutoValue_Snapshot_Request_UpdatePayload.Builder();
        }

        public static RollbackPayload createRollbackPayload(String snapshotId, String storageId) {
            return new AutoValue_Snapshot_Request_RollbackPayload(snapshotId, storageId);
        }

        @AutoValue
        public static abstract class RollbackPayload {
            public abstract String snapshotId();

            public abstract String storageId();
        }

        @AutoValue
        public static abstract class UpdatePayload {
            public abstract String id();

            @Nullable
            public abstract String description();

            @Nullable
            public abstract String name();

            @Nullable
            public abstract Boolean bootable();

            @Nullable
            public abstract OsType osType();

            @Nullable
            public abstract Boolean isCpuHotPlug();

            @Nullable
            public abstract Boolean isCpuHotUnPlug();

            @Nullable
            public abstract Boolean isRamHotPlug();

            @Nullable
            public abstract Boolean isRamHotUnPlug();

            @Nullable
            public abstract Boolean isNicHotPlug();

            @Nullable
            public abstract Boolean isNicHotUnPlug();

            @Nullable
            public abstract Boolean isDiscVirtioHotPlug();

            @Nullable
            public abstract Boolean isDiscVirtioHotUnPlug();

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder id(String var1);

                public abstract Builder description(String var1);

                public abstract Builder name(String var1);

                public abstract Builder bootable(Boolean var1);

                public abstract Builder osType(OsType var1);

                public abstract Builder isCpuHotPlug(Boolean var1);

                public abstract Builder isCpuHotUnPlug(Boolean var1);

                public abstract Builder isRamHotPlug(Boolean var1);

                public abstract Builder isRamHotUnPlug(Boolean var1);

                public abstract Builder isNicHotPlug(Boolean var1);

                public abstract Builder isNicHotUnPlug(Boolean var1);

                public abstract Builder isDiscVirtioHotPlug(Boolean var1);

                public abstract Builder isDiscVirtioHotUnPlug(Boolean var1);

                public abstract UpdatePayload build();
            }
        }

        @AutoValue
        public static abstract class CreatePayload {
            public abstract String storageId();

            public abstract String name();

            @Nullable
            public abstract String description();

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder storageId(String var1);

                public abstract Builder name(String var1);

                public abstract Builder description(String var1);

                public abstract CreatePayload build();
            }
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder size(Float var1);

        public abstract Builder location(Location var1);

        public abstract Builder osType(OsType var1);

        public abstract Builder isBootable(Boolean var1);

        public abstract Builder description(String var1);

        public abstract Builder creationTime(Date var1);

        public abstract Builder lastModificationTime(Date var1);

        public abstract Builder state(ProvisioningState var1);

        public abstract Builder isCpuHotPlug(Boolean var1);

        public abstract Builder isCpuHotUnPlug(Boolean var1);

        public abstract Builder isRamHotPlug(Boolean var1);

        public abstract Builder isRamHotUnPlug(Boolean var1);

        public abstract Builder isNicHotPlug(Boolean var1);

        public abstract Builder isNicHotUnPlug(Boolean var1);

        public abstract Builder isDiscVirtioHotPlug(Boolean var1);

        public abstract Builder isDiscVirtioHotUnPlug(Boolean var1);

        public abstract Snapshot build();
    }
}

