/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.profitbricks.domain.AutoValue_Nic;
import org.jclouds.profitbricks.domain.AutoValue_Nic_Request_CreatePayload;
import org.jclouds.profitbricks.domain.AutoValue_Nic_Request_SetInternetAccessPayload;
import org.jclouds.profitbricks.domain.AutoValue_Nic_Request_UpdatePayload;
import org.jclouds.profitbricks.domain.Firewall;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.util.Preconditions;

@AutoValue
public abstract class Nic {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract String dataCenterId();

    @Nullable
    public abstract Integer lanId();

    @Nullable
    public abstract Boolean internetAccess();

    @Nullable
    public abstract String serverId();

    @Nullable
    public abstract List<String> ips();

    @Nullable
    public abstract String macAddress();

    @Nullable
    public abstract Firewall firewall();

    @Nullable
    public abstract Boolean dhcpActive();

    @Nullable
    public abstract String gatewayIp();

    @Nullable
    public abstract ProvisioningState state();

    public static Builder builder() {
        return new AutoValue_Nic.Builder().ips((List<String>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder dataCenterId(String var1);

        public abstract Builder lanId(Integer var1);

        public abstract Builder internetAccess(Boolean var1);

        public abstract Builder serverId(String var1);

        public abstract Builder ips(List<String> var1);

        public abstract Builder macAddress(String var1);

        public abstract Builder firewall(Firewall var1);

        public abstract Builder dhcpActive(Boolean var1);

        public abstract Builder gatewayIp(String var1);

        public abstract Builder state(ProvisioningState var1);

        abstract Nic autoBuild();

        public Nic build() {
            Nic nic = this.autoBuild();
            if (nic.ips() != null) {
                Preconditions.checkIps(nic.ips());
            }
            if (nic.gatewayIp() != null) {
                Preconditions.checkIp(nic.gatewayIp());
            }
            if (nic.lanId() != null) {
                Preconditions.checkLanId(nic.lanId());
            }
            if (nic.macAddress() != null) {
                Preconditions.checkMacAddress(nic.macAddress());
            }
            return nic.toBuilder().ips((List<String>)ImmutableList.copyOf(nic.ips())).autoBuild();
        }
    }

    public static final class Request {
        public static CreatePayload.Builder creatingBuilder() {
            return new AutoValue_Nic_Request_CreatePayload.Builder();
        }

        public static UpdatePayload.Builder updatingBuilder() {
            return new AutoValue_Nic_Request_UpdatePayload.Builder();
        }

        public static SetInternetAccessPayload.Builder setInternetAccessBuilder() {
            return new AutoValue_Nic_Request_SetInternetAccessPayload.Builder();
        }

        @AutoValue
        public static abstract class SetInternetAccessPayload {
            public abstract String dataCenterId();

            public abstract int lanId();

            public abstract boolean internetAccess();

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder dataCenterId(String var1);

                public abstract Builder lanId(int var1);

                public abstract Builder internetAccess(boolean var1);

                public abstract SetInternetAccessPayload build();
            }
        }

        @AutoValue
        public static abstract class UpdatePayload {
            public abstract String id();

            @Nullable
            public abstract String ip();

            @Nullable
            public abstract String name();

            @Nullable
            public abstract Boolean dhcpActive();

            @Nullable
            public abstract Integer lanId();

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder id(String var1);

                public abstract Builder ip(String var1);

                public abstract Builder name(String var1);

                public abstract Builder dhcpActive(Boolean var1);

                public abstract Builder lanId(Integer var1);

                abstract UpdatePayload autoBuild();

                public UpdatePayload build() {
                    UpdatePayload payload = this.autoBuild();
                    if (payload.ip() != null) {
                        Preconditions.checkIp(payload.ip());
                    }
                    if (payload.lanId() != null) {
                        Preconditions.checkLanId(payload.lanId());
                    }
                    return payload;
                }
            }
        }

        @AutoValue
        public static abstract class CreatePayload {
            public abstract String serverId();

            public abstract int lanId();

            @Nullable
            public abstract String ip();

            @Nullable
            public abstract String name();

            @Nullable
            public abstract Boolean dhcpActive();

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder serverId(String var1);

                public abstract Builder lanId(int var1);

                public abstract Builder ip(String var1);

                public abstract Builder name(String var1);

                public abstract Builder dhcpActive(Boolean var1);

                abstract CreatePayload autoBuild();

                public CreatePayload build() {
                    CreatePayload payload = this.autoBuild();
                    if (payload.ip() != null) {
                        Preconditions.checkIp(payload.ip());
                    }
                    Preconditions.checkLanId(payload.lanId());
                    return payload;
                }
            }
        }
    }
}

