/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.domain;

import com.google.auto.value.AutoValue;
import com.google.common.base.Enums;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.profitbricks.domain.AutoValue_Firewall;
import org.jclouds.profitbricks.domain.AutoValue_Firewall_Request_AddRulePayload;
import org.jclouds.profitbricks.domain.AutoValue_Firewall_Rule;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.util.Preconditions;

@AutoValue
public abstract class Firewall {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String nicId();

    @Nullable
    public abstract Boolean active();

    @Nullable
    public abstract ProvisioningState state();

    @Nullable
    public abstract List<Rule> rules();

    public static Builder builder() {
        return new AutoValue_Firewall.Builder().rules((List<Rule>)ImmutableList.of());
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder nicId(String var1);

        public abstract Builder active(Boolean var1);

        public abstract Builder state(ProvisioningState var1);

        public abstract Builder rules(List<Rule> var1);

        abstract Firewall autoBuild();

        public Firewall build() {
            Firewall built = this.autoBuild();
            return built.toBuilder().rules((List<Rule>)ImmutableList.copyOf(built.rules())).autoBuild();
        }
    }

    @AutoValue
    public static abstract class Rule {
        @Nullable
        public abstract String id();

        @Nullable
        public abstract String name();

        @Nullable
        public abstract Integer portRangeEnd();

        @Nullable
        public abstract Integer portRangeStart();

        @Nullable
        public abstract Protocol protocol();

        @Nullable
        public abstract String sourceIp();

        @Nullable
        public abstract String sourceMac();

        @Nullable
        public abstract String targetIp();

        @Nullable
        public abstract Integer icmpCode();

        @Nullable
        public abstract Integer icmpType();

        public static Builder builder() {
            return new AutoValue_Firewall_Rule.Builder().protocol(Protocol.ANY);
        }

        public abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder id(String var1);

            public abstract Builder name(String var1);

            public abstract Builder portRangeEnd(Integer var1);

            public abstract Builder portRangeStart(Integer var1);

            public abstract Builder protocol(Protocol var1);

            public abstract Builder sourceIp(String var1);

            public abstract Builder sourceMac(String var1);

            public abstract Builder targetIp(String var1);

            public abstract Builder icmpCode(Integer var1);

            public abstract Builder icmpType(Integer var1);

            abstract Rule autoBuild();

            public Rule build() {
                Rule rule = this.autoBuild();
                if (rule.sourceIp() != null) {
                    Preconditions.checkIp(rule.sourceIp());
                }
                if (rule.targetIp() != null) {
                    Preconditions.checkIp(rule.targetIp());
                }
                if (rule.sourceMac() != null) {
                    Preconditions.checkMacAddress(rule.sourceMac());
                }
                Preconditions.checkPortRange(rule.portRangeStart(), rule.portRangeEnd(), rule.protocol());
                Preconditions.checkIcmp(rule.icmpType(), rule.icmpCode(), rule.protocol());
                return rule;
            }
        }
    }

    public static final class Request {
        public static AddRulePayload createAddRulePayload(String nicId, List<Rule> rules) {
            return new AutoValue_Firewall_Request_AddRulePayload(nicId, (List<Rule>)ImmutableList.copyOf(rules));
        }

        @AutoValue
        public static abstract class AddRulePayload {
            public abstract String nicId();

            public abstract List<Rule> rules();
        }
    }

    public static enum Protocol {
        TCP,
        UDP,
        ICMP,
        ANY,
        UNRECOGNIZED;


        public static Protocol fromValue(String value) {
            return (Protocol)((Object)Enums.getIfPresent(Protocol.class, (String)value).or((Object)UNRECOGNIZED));
        }
    }
}

